import { Instance } from "tippy.js";
import { HTMLElementWithTooltip } from "../components/onto-tooltip/models/html-element-with-tooltip";
export declare class TooltipUtil {
    private static readonly ATTR_CONTENT;
    private static readonly ATTR_THEME;
    private static readonly ATTR_PLACEMENT;
    private static readonly ATTR_TRIGGER;
    private static readonly ATTR_APPEND_TO;
    private static readonly TOOLTIP_CLASS;
    /**
     * Returns the Tippy instance associated with an element, if it exists.
     */
    static getTooltipInstance(element: HTMLElement): Instance | undefined;
    /**
     * Creates a new Tippy tooltip instance on the given element using
     * the OntoTooltipConfiguration.
     *
     * @param target - The HTMLElement to attach the tooltip to.
     * @returns The newly created Tippy Instance.
     */
    static createTooltip(target: HTMLElement): Instance;
    /**
     * Returns an existing Tippy instance or creates a new one if not present.
     *
     * @param target - The HTMLElement to find or attach the tooltip to.
     * @returns The existing or newly created Tippy Instance.
     */
    static getOrCreateTooltipInstance(target: HTMLElement): Instance;
    private static getConfig;
    /**
     * Updates the content of an existing Tippy tooltip, if present.
     * Does nothing if tooltip does not exist or content is empty.
     */
    static updateTooltipContent(target: HTMLElement, content: string): void;
    /**
     * Destroys the Tippy tooltip on the given element, if present.
     */
    static destroyTooltip(target: HTMLElement): void;
    /**
     * Recursively finds the closest ancestor (including the given element itself) that has a `tooltip-content` attribute.
     * This is used to identify the element associated with a tooltip when an event occurs on a child element.
     *
     * @param element - The starting HTML element where the search begins.
     * @returns The closest HTML element with the `tooltip-content` attribute, or `null` if no such element is found.
     */
    static getTooltipTarget(element: HTMLElement): HTMLElementWithTooltip | null;
}
