import { EventEmitter } from '../../stencil-public-runtime';
import { ExternalMenuModel } from "./external-menu-model";
import { NavbarToggledEvent } from "./navbar-toggled-event";
export declare class OntoNavbar {
    private readonly productInfoContextService;
    private readonly subscriptions;
    private labels;
    private productInfo;
    /**
     * Flag indicating whether the navbar is collapsed in result of toggle action initiated by the user. This is needed
     * in cases where the browser window is resized which is an operation that should not override the user's choice
     * regarding the navbar collapsed state, e.g. if the user has manually collapsed the navbar and then resizes the
     * window, the navbar should remain collapsed.
     */
    private isCollapsedByUser;
    hostElement: HTMLOntoNavbarElement;
    /**
     * The internal menu model used for UI rendering.
     */
    private menuModel;
    /**
     * Controls the expanded/collapsed state of the navbar.
     */
    private isCollapsed;
    /**
     * Configuration whether the navbar should be collapsed.
     */
    navbarCollapsed: boolean;
    navbarCollapsedChange(collapsed: boolean): void;
    /**
     * Configuration for the menu items model. This is the external model that is used to build the internal model.
     */
    menuItems: ExternalMenuModel;
    menuItemsChanged(menuItems: ExternalMenuModel): void;
    /**
     * Event fired when the navbar is toggled.
     */
    navbarToggled: EventEmitter<NavbarToggledEvent>;
    private init;
    private select;
    private subscribeToNavigationEnd;
    private selectItemByUrl;
    private toggleNavbar;
    private collapseNavbar;
    private expandNavbar;
    private refreshNavbar;
    private onLanguageChanged;
    private onTranslate;
    componentWillLoad(): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private handleSelectMenuItem;
    private toggleNavbarHandler;
    render(): any;
    private subscribeToProductInfoChanges;
}
