import { LocalStorageService } from '../storage';
import { StorageData } from '../../models/storage';
/**
 * A service for managing authentication-related local storage operations.
 */
export declare class AuthenticationStorageService extends LocalStorageService {
    private readonly jwtKey;
    private readonly authenticatedKey;
    readonly NAMESPACE = "auth";
    set(key: string, value: string): void;
    /**
     * Retrieves the authentication token from storage.
     * @returns The stored authentication token as StorageData.
     */
    getAuthToken(): StorageData;
    setAuthenticated(authenticated: boolean): void;
    isAuthenticated(): boolean;
}
