import { Service } from '../../providers/service/service';
import { Repository, RepositoryList } from '../../models/repositories';
import { RepositorySizeInfo } from '../../models/repositories';
/**
 * The RepositoryService class is responsible for fetching repository-related data from the backend
 * and mapping the responses to application models.
 */
export declare class RepositoryService implements Service {
    private readonly GRAPHQL_REPO_AUTHORITY;
    private repositoryRestService;
    private repositoryListMapper;
    private repositorySizeInfoMapper;
    constructor();
    /**
     * Retrieves the list of repositories.
     *
     * @returns A promise that resolves to the list of repositories.
     */
    getRepositories(): Promise<RepositoryList>;
    /**
     * Retrieves triple information for the specified <code>repository</code>.
     *
     * @param repository The repository for which to retrieve size information.
     * @returns A promise that resolves to a {@link RepositorySizeInfo} object containing the repository's triple details.
     */
    getRepositorySizeInfo(repository: Repository): Promise<RepositorySizeInfo>;
    isSystemRepository(repository: Repository): boolean;
    getCurrentGqlRepoAuthority(action: string, repoId: string): string;
    getOverallGqlRepoAuthority(action: string): string;
    getLocationSpecificId(repo: Repository): string;
    getCurrentRepoAuthority(action: string, repoId: string): string;
    getOverallRepoAuthority(action: string): string;
}
