import { Service } from '../../providers/service/service';
import { OperationStatusSummary } from '../../models/monitoring/operation-status-summary';
/**
 * Service class for handling operations-related functionality.
 */
export declare class MonitoringService implements Service {
    /**
     * Retrieves the status summary of operations.
     *
     * @returns {Promise<OperationStatusSummary>} A Promise that resolves to an OperationStatusSummary object,
     *          representing the current status of operations.
     */
    getOperations(repositoryId: string): Promise<OperationStatusSummary>;
}
