import { Mapper } from '../../../providers/mapper/mapper';
import { OperationList } from '../../../models/monitoring/operation-list';
import { Operation } from '../../../models/monitoring/operation';
/**
 * Mapper class for converting an array of Operation objects to an OperationList model.
 */
export declare class OperationListMapper extends Mapper<OperationList> {
    /**
     * Maps an array of Operation objects to an OperationList model.
     * Sorts the operations by their type before mapping them to the OperationList model.
     *
     * @param data - An array of Operation objects to be mapped into an OperationList.
     * @returns A new OperationList instance containing the provided operations.
     */
    mapToModel(data: Operation[]): OperationList;
}
