import { Service } from '../../providers/service/service';
export declare const COOKIE_CONSENT_CHANGED_EVENT = "cookie-consent-changed-event";
/**
 * Service class for handling cookie-related operations.
 */
export declare class CookieService implements Service {
    private readonly eventEmitter;
    /**
     * Accepts the cookie policy for the authenticated user.
     *
     * @returns {Promise<void>} - A promise that resolves when the request to the backend has passed.
     */
    acceptCookiePolicy(): Promise<void>;
    private setAcceptedCookiePolicy;
}
