import { ContextService } from '../context';
import { DeriveContextServiceContract } from '../../models/context/update-context-method';
import { Configuration } from '../../models/configuration';
type ConfigurationContextFields = {
    readonly APPLICATION_CONFIGURATION: string;
};
type ConfigurationContextFieldParams = {
    readonly APPLICATION_CONFIGURATION: Configuration;
};
/**
 * The ConfigurationContextService class manages the application's configuration context.
 * It allows updating and retrieving the application configuration.
 */
export declare class ConfigurationContextService extends ContextService<ConfigurationContextFields> implements DeriveContextServiceContract<ConfigurationContextFields, ConfigurationContextFieldParams> {
    readonly APPLICATION_CONFIGURATION = "applicationConfiguration";
    updateApplicationConfiguration(configuration: Configuration): void;
    getApplicationConfiguration(): Configuration;
}
export {};
