/**
 * Represents a map between prefixes and their corresponding URIs.
 */
export declare class NamespaceMap {
    private namespaces;
    constructor(namespaces: Record<string, string>);
    setNamespaces(namespaces: Record<string, string>): void;
    /**
     * Retrieves the URI for a given prefix.
     * @param prefix - The prefix for which to retrieve the URI.
     */
    getByPrefix(prefix: string): string;
}
