import { Model } from '../common/model';
import { CapabilityList } from './capability-list';
/**
 * Represents a Graph DB license.
 *
 * Inherits copy functionality from {@link Model} and contains various properties of a GraphDB license.
 */
export declare class License extends Model<License> {
    private _expiryDate?;
    private _latestPublicationDate?;
    private _licensee?;
    private _maxCpuCores?;
    private _product?;
    private _productType?;
    private _licenseCapabilities?;
    private _version?;
    private _installationId?;
    private _valid?;
    private _typeOfUse?;
    private _message?;
    private _present?;
    private _usageRestriction?;
    /**
     * Creates a new License instance.
     *
     * @param data - Partial data to initialize the License object. This can include any of the properties
     * defined in the License class. Default values are applied for some properties if not provided.
     */
    constructor(data: Partial<License>);
    get expiryDate(): number | undefined;
    set expiryDate(value: number | undefined);
    get latestPublicationDate(): number | undefined;
    set latestPublicationDate(value: number | undefined);
    get licensee(): string | undefined;
    set licensee(value: string | undefined);
    get maxCpuCores(): number | undefined;
    set maxCpuCores(value: number | undefined);
    get product(): string | undefined;
    set product(value: string | undefined);
    get productType(): string | undefined;
    set productType(value: string | undefined);
    get licenseCapabilities(): CapabilityList | undefined;
    set licenseCapabilities(value: CapabilityList | undefined);
    get version(): string | undefined;
    set version(value: string | undefined);
    get installationId(): string | undefined;
    set installationId(value: string | undefined);
    get valid(): boolean | undefined;
    set valid(value: boolean | undefined);
    get typeOfUse(): string | undefined;
    set typeOfUse(value: string | undefined);
    get message(): string | undefined;
    set message(value: string | undefined);
    get present(): boolean | undefined;
    set present(value: boolean | undefined);
    get usageRestriction(): string | undefined;
    set usageRestriction(value: string | undefined);
}
