/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.model.Collation;
import com.ontotext.trree.plugin.mongodb.Configuration;
import com.ontotext.trree.plugin.mongodb.MongoResultIterator;
import com.ontotext.trree.plugin.mongodb.RequestCache;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.PluginTransactionListener;
import com.ontotext.trree.sdk.Preprocessor;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.UpdateInterpreter;
import com.ontotext.trree.sdk.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class MongoDBPlugin
extends PluginBase
implements Preprocessor,
PatternInterpreter,
UpdateInterpreter,
PluginTransactionListener {
    public static final String NAMESPACE = "http://www.ontotext.com/connectors/mongodb#";
    public static final String NAMESPACE_INST = "http://www.ontotext.com/connectors/mongodb/instance#";
    public static final IRI SERVICE = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#service");
    public static final IRI DATABASE = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#database");
    public static final IRI COLLECTION = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#collection");
    public static final IRI USER = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#user");
    public static final IRI PASSWORD = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#password");
    public static final IRI AUTH_DB = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#authDb");
    public static final IRI DROP = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#drop");
    public static final IRI QUERY = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#find");
    public static final IRI PROJECTION = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#project");
    public static final IRI AGGREGATION = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#aggregate");
    public static final IRI HINT = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#hint");
    public static final IRI ENTITY = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#entity");
    public static final IRI GRAPH = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#graph");
    public static final IRI COLLATION = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#collation");
    public static final IRI BATCH = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/mongodb#batchSize");
    protected static final String MONGODB_PROPERTIES = "mongodb.properties";
    private int maxBatchSize = 1000;
    protected ValueFactory vf = SimpleValueFactory.getInstance();
    long serviceId = 0L;
    long databaseId = 0L;
    long collectionId = 0L;
    long userId = 0L;
    long passwordId = 0L;
    long authDbId = 0L;
    long dropId = 0L;
    long queryId = 0L;
    long projectionId = 0L;
    long aggregationId = 0L;
    long hintId = 0L;
    long entityId = 0L;
    long graphId = 0L;
    long rdf_type = 0L;
    long collationId = 0L;
    long batchSize = 0L;
    protected long[] predicateSet;
    protected Map<String, Configuration> configMap = new HashMap<String, Configuration>();
    protected Map<String, MongoClient> mongoClients = new HashMap<String, MongoClient>();

    public String getName() {
        return "mongodb";
    }

    public void initialize(InitReason initReason, PluginConnection pluginConnection) {
        this.maxBatchSize = this.readMaxBatchSizeConfig();
        Entities entities = pluginConnection.getEntities();
        this.serviceId = entities.put((Value)SERVICE, Entities.Scope.SYSTEM);
        this.databaseId = entities.put((Value)DATABASE, Entities.Scope.SYSTEM);
        this.collectionId = entities.put((Value)COLLECTION, Entities.Scope.SYSTEM);
        this.userId = entities.put((Value)USER, Entities.Scope.SYSTEM);
        this.passwordId = entities.put((Value)PASSWORD, Entities.Scope.SYSTEM);
        this.authDbId = entities.put((Value)AUTH_DB, Entities.Scope.SYSTEM);
        this.dropId = entities.put((Value)DROP, Entities.Scope.SYSTEM);
        this.queryId = entities.put((Value)QUERY, Entities.Scope.SYSTEM);
        this.projectionId = entities.put((Value)PROJECTION, Entities.Scope.SYSTEM);
        this.aggregationId = entities.put((Value)AGGREGATION, Entities.Scope.SYSTEM);
        this.hintId = entities.put((Value)HINT, Entities.Scope.SYSTEM);
        this.entityId = entities.put((Value)ENTITY, Entities.Scope.SYSTEM);
        this.graphId = entities.put((Value)GRAPH, Entities.Scope.SYSTEM);
        this.rdf_type = entities.resolve((Value)RDF.TYPE);
        this.collationId = entities.put((Value)COLLATION, Entities.Scope.SYSTEM);
        this.batchSize = entities.put((Value)BATCH, Entities.Scope.SYSTEM);
        this.predicateSet = new long[]{this.serviceId, this.databaseId, this.collectionId, this.userId, this.passwordId, this.authDbId, this.dropId, this.queryId, this.projectionId, this.aggregationId, this.hintId, this.entityId, this.graphId, this.collationId, this.batchSize, this.rdf_type};
        Arrays.sort(this.predicateSet);
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        String suffix;
        ContextImpl ctx;
        ContextImpl contextImpl = ctx = requestContext instanceof ContextImpl ? (ContextImpl)requestContext : null;
        if (predicate == this.rdf_type && ctx != null && ctx.iters != null && object != 0L && object != Long.MAX_VALUE && (suffix = Utils.matchPrefix((String)pluginConnection.getEntities().get(object).stringValue(), (Object[])new Object[]{NAMESPACE_INST})) != null && suffix.length() > 0) {
            return 0.3;
        }
        if (predicate == this.graphId) {
            return 0.35;
        }
        if (predicate == this.batchSize) {
            return 0.37;
        }
        if (predicate == this.aggregationId) {
            return 0.39;
        }
        if (predicate == this.queryId) {
            return 0.43;
        }
        if (predicate == this.collationId) {
            return 0.45;
        }
        if (predicate == this.projectionId) {
            return 0.46;
        }
        if (predicate == this.hintId) {
            return 0.49;
        }
        if (predicate == this.entityId) {
            return 0.52;
        }
        if (ctx != null && ctx.iters != null && ctx.getContexts().contains(context)) {
            return 0.6;
        }
        return 0.0;
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        String suffix;
        Object iter;
        Object ns;
        Value val;
        ContextImpl ctx;
        ContextImpl contextImpl = ctx = requestContext instanceof ContextImpl ? (ContextImpl)requestContext : null;
        if (ctx == null) {
            return StatementIterator.EMPTY;
        }
        Entities entities = pluginConnection.getEntities();
        if (predicate != 0L && context == 0L && (val = entities.get(predicate)) != null && val instanceof IRI && (NAMESPACE.equals(ns = ((IRI)val).getNamespace()) || NAMESPACE_INST.equals(ns)) && Arrays.binarySearch(this.predicateSet, predicate) < 0) {
            throw new PluginException("Found unrecognized predicate in the MongoDB namespace: " + val.stringValue());
        }
        if (ctx.entities == null) {
            ctx.entities = entities;
        }
        if (this.rdf_type == 0L) {
            this.rdf_type = entities.resolve((Value)RDF.TYPE);
            if (this.rdf_type == 0L) {
                return null;
            }
        }
        if (predicate == this.rdf_type && context == 0L) {
            Object config;
            if (object >= 0L) {
                return null;
            }
            String suffix2 = Utils.matchPrefix((String)Utils.getString((Entities)entities, (long)object), (Object[])new Object[]{NAMESPACE_INST});
            if (suffix2 == null) {
                return null;
            }
            if (ctx.iters != null) {
                for (MongoResultIterator it : ctx.iters) {
                    if (it instanceof LazyMongoResultIterator && ((LazyMongoResultIterator)it).isNotBound() || it.getQueryIdentifier() != object || it.isQuerySet() && !it.isCloned() || it.isClosed()) continue;
                    ctx.setPhase(ContextPhase.SEARCH_DEFINITION);
                    return it;
                }
            }
            if ((config = this.resolveConfiguration(suffix2)) == null) {
                return StatementIterator.EMPTY;
            }
            String connectString = ((Configuration)config).getConnectionString();
            if (connectString == null || connectString.trim().length() == 0) {
                this.getLogger().error("Invalid connect parameters for MongoDB inst {}!", (Object)suffix2);
                return StatementIterator.EMPTY;
            }
            ctx.searchBNode = entities.put((Value)this.vf.createBNode(), Entities.Scope.REQUEST);
            ctx.setPhase(ContextPhase.SEARCH_DEFINITION);
            ctx.addContext(object);
            MongoResultIterator mainIterator = this.createMainIterator((Configuration)config, ctx, object, 0L);
            for (MongoResultIterator it : ctx.iters) {
                if (!(it instanceof LazyMongoResultIterator) || ((LazyMongoResultIterator)it).getDelegate() != mainIterator) continue;
                return it;
            }
            return mainIterator;
        }
        if (predicate == this.graphId) {
            if (ctx.iters == null) {
                this.getLogger().error("iter not created yet");
                return StatementIterator.EMPTY;
            }
            MongoResultIterator resultIterator = null;
            if (subject != 0L) {
                for (MongoResultIterator it : ctx.iters) {
                    if (it.getSearchSubject() != subject || it.isClosed()) continue;
                    resultIterator = it;
                    break;
                }
            }
            if (resultIterator == null) {
                iter = ctx.iters.descendingIterator();
                while (iter.hasNext()) {
                    MongoResultIterator curr = (MongoResultIterator)((Object)iter.next());
                    if (curr.getGraphId() != object || curr.isClosed()) continue;
                    resultIterator = curr;
                    break;
                }
            }
            if (resultIterator == null) {
                resultIterator = ctx.iters.getLast();
            }
            if (object != 0L) {
                resultIterator.setGraphId(object);
                ctx.addContext(object);
            }
            return resultIterator.singletonIterator(this.queryId, object);
        }
        if (predicate == this.queryId) {
            String queryString = Utils.getString((Entities)entities, (long)object);
            if (ctx.iters == null) {
                this.getLogger().error("iter not created yet");
                return StatementIterator.EMPTY;
            }
            iter = this.getIterator(subject, context, ctx);
            ((MongoResultIterator)((Object)iter)).setQuery(queryString);
            return ((MongoResultIterator)((Object)iter)).singletonIterator(this.queryId, object);
        }
        if (predicate == this.projectionId) {
            String projectionString = Utils.getString((Entities)entities, (long)object);
            if (ctx.iters == null) {
                this.getLogger().error("iter not created yet");
                return StatementIterator.EMPTY;
            }
            iter = this.getIterator(subject, context, ctx);
            ((MongoResultIterator)((Object)iter)).setProjection(projectionString);
            return ((MongoResultIterator)((Object)iter)).singletonIterator(this.projectionId, object);
        }
        if (predicate == this.aggregationId) {
            if (ctx.iters == null) {
                this.getLogger().error("iter not created yet");
                return StatementIterator.EMPTY;
            }
            String aggregationString = Utils.getString((Entities)entities, (long)object);
            if (aggregationString == null) {
                iter = this.getIterator(subject, context, ctx);
                ((MongoResultIterator)((Object)iter)).setAggregation(null);
                return ((MongoResultIterator)((Object)iter)).singletonIterator(this.aggregationId, object);
            }
            LinkedList<Document> aggregation = new LinkedList<Document>();
            try {
                for (BsonValue doc : BsonArray.parse((String)aggregationString)) {
                    aggregation.add(Document.parse((String)((BsonDocument)doc).toJson()));
                }
            }
            catch (Exception e) {
                this.getLogger().error("could not parse aggregation parameter", (Throwable)e);
                return StatementIterator.EMPTY;
            }
            MongoResultIterator iter2 = this.getIterator(subject, context, ctx);
            iter2.setAggregation(aggregation);
            return iter2.singletonIterator(this.aggregationId, object);
        }
        if (predicate == this.collationId) {
            if (ctx.iters == null) {
                this.getLogger().error("iter not created yet");
                return StatementIterator.EMPTY;
            }
            String collationString = Utils.getString((Entities)entities, (long)object);
            iter = this.getIterator(subject, context, ctx);
            ((MongoResultIterator)((Object)iter)).setCollation(collationString);
            return ((MongoResultIterator)((Object)iter)).singletonIterator(this.collationId, object);
        }
        if (predicate == this.batchSize) {
            if (ctx.iters == null) {
                this.getLogger().error("iter not created yet");
                return StatementIterator.EMPTY;
            }
            Integer batchSizeCfg = this.readBatchSize(object, entities);
            if (batchSizeCfg == null) {
                return StatementIterator.EMPTY;
            }
            iter = this.getIterator(subject, context, ctx);
            ((MongoResultIterator)((Object)iter)).setDocumentsLimit(batchSizeCfg);
            return ((MongoResultIterator)((Object)iter)).singletonIterator(this.batchSize, object);
        }
        if (predicate == this.hintId) {
            String hintString = Utils.getString((Entities)entities, (long)object);
            iter = this.getIterator(subject, context, ctx);
            ((MongoResultIterator)((Object)iter)).setHint(hintString);
            return ((MongoResultIterator)((Object)iter)).singletonIterator(this.hintId, object);
        }
        if (predicate == this.entityId) {
            if (ctx.iters == null) {
                this.getLogger().error("iter not created yet");
                return StatementIterator.EMPTY;
            }
            MongoResultIterator iter3 = this.getIterator(subject, context, ctx);
            return iter3.createEntityIter(this.entityId);
        }
        if (context != 0L && (suffix = Utils.matchPrefix((String)entities.get(context).stringValue(), (Object[])new Object[]{NAMESPACE_INST})) != null && suffix.length() > 0) {
            MongoResultIterator iterator;
            if (ctx.iters == null) {
                iterator = this.createMainIterator(context, entities, ctx);
                if (iterator == null) {
                    return StatementIterator.EMPTY;
                }
                return iterator.getModelIterator(subject, predicate, object);
            }
            boolean reuseIterators = subject != 0L || ctx.phase == ContextPhase.MODEL_ITERATION && ctx.previousPhase != ContextPhase.MODEL_ITERATION;
            iterator = this.getIteratorOrNull(subject, context, ctx, reuseIterators);
            if (iterator == null) {
                iterator = this.createMainIterator(context, entities, ctx);
            }
            if (iterator == null) {
                return StatementIterator.EMPTY;
            }
            return iterator.getModelIterator(subject, predicate, object);
        }
        return null;
    }

    private Integer readBatchSize(long object, Entities entities) {
        Integer batchSizeCfg = Utils.getInteger((Entities)entities, (long)object);
        if (batchSizeCfg == null || batchSizeCfg < 0) {
            this.getLogger().error("Invalid batch size configuration: {}", (Object)Utils.getString((Entities)entities, (long)object));
            return null;
        }
        if (batchSizeCfg >= this.maxBatchSize) {
            if (this.maxBatchSize == 0) {
                this.getLogger().warn("Batch document functionality is disabled. Ignoring {} configuration.", (Object)BATCH);
            } else {
                this.getLogger().warn("Batch size {} exceeds maximum {}. Using default size.", (Object)Utils.getString((Entities)entities, (long)object), (Object)this.maxBatchSize);
            }
            batchSizeCfg = this.maxBatchSize;
        }
        return batchSizeCfg;
    }

    private Configuration resolveConfiguration(String suffix) {
        return this.configMap.computeIfAbsent(suffix, indexName -> {
            File indexInst = new File(this.getDataDir(), (String)indexName);
            if (!indexInst.exists()) {
                this.getLogger().error("MongoDB service {} not connected!", indexName);
                return null;
            }
            File propertiesFile = new File(indexInst, MONGODB_PROPERTIES);
            try {
                return Configuration.fromFile(propertiesFile);
            }
            catch (IOException e) {
                this.getLogger().error("Cannot get MongoDB connect parameters {}. Exception {}!", indexName, (Object)e);
                return null;
            }
        });
    }

    public RequestContext preprocess(Request request) {
        ContextImpl impl = new ContextImpl();
        impl.setRequest(request);
        return impl;
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.serviceId, this.databaseId, this.collectionId, this.userId, this.authDbId, this.passwordId, this.dropId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (!isAddition) {
            return false;
        }
        if (predicate == this.serviceId || predicate == this.databaseId || predicate == this.collectionId || predicate == this.userId || predicate == this.passwordId || predicate == this.authDbId) {
            String suffix = Utils.matchPrefix((String)Utils.getString((Entities)pluginConnection.getEntities(), (long)subject), (Object[])new Object[]{NAMESPACE_INST});
            if (suffix == null) {
                this.getLogger().error("No valid localname for the instance when registering a connection to MongoDB");
                return true;
            }
            String value = Utils.getString((Entities)pluginConnection.getEntities(), (long)object);
            Configuration config = this.configMap.computeIfAbsent(suffix, indexName -> {
                File indexFolder = new File(this.getDataDir(), (String)indexName);
                if (!indexFolder.exists()) {
                    this.getLogger().info("Creating a new service in MongoDB: {}", indexName);
                    indexFolder.mkdirs();
                }
                return new Configuration(new File(indexFolder, MONGODB_PROPERTIES));
            });
            if (predicate == this.serviceId) {
                config.setConnectionString(value);
                this.logUpdatedSetting(suffix, "connectionString");
            } else if (predicate == this.databaseId) {
                config.setDatabase(value);
                this.logUpdatedSetting(suffix, "database");
            } else if (predicate == this.collectionId) {
                config.setCollection(value);
                this.logUpdatedSetting(suffix, "collection");
            } else if (predicate == this.userId) {
                config.setUser(value);
                this.logUpdatedSetting(suffix, "user");
            } else if (predicate == this.authDbId) {
                config.setAuthDb(value);
                this.logUpdatedSetting(suffix, "authDb");
            } else if (predicate == this.passwordId) {
                config.setPassword(value);
                this.logUpdatedSetting(suffix, "password");
            }
            return true;
        }
        if (predicate == this.dropId) {
            File indexFolder;
            String suffix = Utils.matchPrefix((String)Utils.getString((Entities)pluginConnection.getEntities(), (long)subject), (Object[])new Object[]{NAMESPACE_INST});
            if (suffix == null) {
                this.getLogger().error("No valid localname for the instance when registering a connection to MongoDB");
                return true;
            }
            Configuration conf = this.configMap.remove(suffix);
            if (conf != null) {
                conf.delete();
            }
            if ((indexFolder = new File(this.getDataDir(), suffix)).exists()) {
                try {
                    FileUtils.deleteDirectory((File)indexFolder);
                    this.getLogger().info("MongoDB service {} removed successfully", (Object)suffix);
                }
                catch (IOException e) {
                    this.getLogger().error("Cannot remove folder {} for MongoDB service {}!", (Object)indexFolder.getAbsolutePath(), (Object)suffix);
                }
            } else {
                this.getLogger().warn("Could not remove MongoDB service {} because it was not registered!", (Object)suffix);
            }
            return true;
        }
        return false;
    }

    protected MongoResultIterator getIterator(long subject, long context, ContextImpl ctx) {
        MongoResultIterator iterator = this.getIteratorOrNull(subject, context, ctx, true);
        if (iterator == null) {
            Iterator<MongoResultIterator> iter = ctx.iters.descendingIterator();
            while (iter.hasNext()) {
                MongoResultIterator next = iter.next();
                if (next.isClosed()) continue;
                return next;
            }
            return ctx.iters.getLast();
        }
        return iterator;
    }

    protected MongoResultIterator getIteratorOrNull(long subject, long context, ContextImpl ctx, boolean canReuseIterators) {
        if (subject != 0L) {
            for (MongoResultIterator it : ctx.iters) {
                if (it.getSearchSubject() != subject || it.isClosed()) continue;
                return it;
            }
        }
        if (context != 0L) {
            Iterator<MongoResultIterator> iter = ctx.iters.descendingIterator();
            while (iter.hasNext()) {
                MongoResultIterator curr = iter.next();
                if (curr.getQueryIdentifier() != context || curr.isClosed() || !canReuseIterators && curr.isContextFirst() && curr.isQuerySet() && curr.isModelIteratorCreated() && curr.isEntityIteratorCreated()) continue;
                return curr;
            }
        }
        return null;
    }

    protected MongoResultIterator createMainIterator(long graphId, Entities entities, ContextImpl ctx) {
        String suffix = Utils.matchPrefix((String)entities.get(graphId).stringValue(), (Object[])new Object[]{NAMESPACE_INST});
        if (StringUtils.isBlank((CharSequence)suffix)) {
            this.getLogger().error("Invalid MongoDB inst {}!", (Object)suffix);
            return null;
        }
        Configuration config = this.resolveConfiguration(suffix);
        if (config == null) {
            LazyMongoResultIterator resultIterator = new LazyMongoResultIterator(graphId, ctx);
            ctx.addIterator(resultIterator);
            ctx.setPhase(ContextPhase.MODEL_ITERATION);
            return resultIterator;
        }
        if (StringUtils.isBlank((CharSequence)config.getConnectionString())) {
            this.getLogger().error("Invalid connect parameters for MongoDB inst {}!", (Object)suffix);
            return null;
        }
        ctx.searchBNode = entities.put((Value)this.vf.createBNode(), Entities.Scope.REQUEST);
        ctx.addContext(graphId);
        MongoResultIterator previousIterator = null;
        if (ctx.iters != null && graphId != 0L) {
            Iterator<MongoResultIterator> iter = ctx.iters.descendingIterator();
            while (iter.hasNext()) {
                MongoResultIterator curr = iter.next();
                if (curr.getQueryIdentifier() != graphId || !curr.isClosed()) continue;
                previousIterator = curr;
                break;
            }
        }
        MongoResultIterator mainIterator = this.createMainIterator(config, ctx, 0L, graphId);
        mainIterator.setContextFirst(true);
        ctx.setPhase(ContextPhase.MODEL_ITERATION);
        if (previousIterator != null) {
            mainIterator.setCloned(true);
            mainIterator.setQuery(previousIterator.getQuery());
            mainIterator.setAggregation(previousIterator.getAggregation());
            mainIterator.setCollation(previousIterator.getCollation());
            mainIterator.setHint(previousIterator.getHint());
            mainIterator.setProjection(previousIterator.getProjection());
        }
        return mainIterator;
    }

    protected MongoResultIterator createMainIterator(Configuration configuration, ContextImpl ctx, long indexId, long graphId) {
        String connect = configuration.getConnectionString();
        String database = configuration.getDatabase();
        String collection = configuration.getCollection();
        Optional<MongoCredential> mongoCredential = configuration.getMongoCredential();
        MongoClient client = this.mongoClients.computeIfAbsent(connect + mongoCredential.map(credential -> credential.getUserName() + "_" + credential.getSource()).orElse(""), s -> {
            MongoClientSettings.Builder builder = MongoClientSettings.builder();
            builder.applyConnectionString(new ConnectionString(connect));
            mongoCredential.ifPresent(arg_0 -> ((MongoClientSettings.Builder)builder).credential(arg_0));
            return MongoClients.create((MongoClientSettings)builder.build());
        });
        MongoResultIterator ret = new MongoResultIterator(this, client, database, collection, ctx.cache, ctx.searchBNode);
        ret.setEntities(ctx.entities);
        ret.setIndexId(indexId);
        ret.setGraphId(graphId);
        ctx.addIterator(ret);
        return ret;
    }

    public void transactionStarted(PluginConnection pluginConnection) {
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
    }

    public void transactionAborted(PluginConnection pluginConnection) {
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        for (Map.Entry<String, Configuration> entry : this.configMap.entrySet()) {
            if (!entry.getValue().isDirty()) continue;
            try {
                entry.getValue().persist();
            }
            catch (IOException e) {
                this.getLogger().error("cannot register mongoDB connection into {} for index {}. IOException {}", new Object[]{entry.getValue().getPropertiesFilePath(), entry.getKey(), e});
                throw new PluginException("Could not persist mongo configuration: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void shutdown(ShutdownReason shutdownReason) {
        for (MongoClient client : this.mongoClients.values()) {
            client.close();
        }
    }

    private void logUpdatedSetting(String suffix, String setting) {
        this.getLogger().info("Setting {} for MongoDB service {}", (Object)setting, (Object)suffix);
    }

    private int readMaxBatchSizeConfig() {
        int maxBatch;
        try {
            maxBatch = Integer.parseInt(System.getProperty("graphdb.mongodb.maxBatchSize", "1000"));
        }
        catch (NumberFormatException e) {
            this.getLogger().error("Invalid graphdb.mongodb.maxBatchSize: {}. Setting default 1000 as fallback.", (Object)System.getProperty("graphdb.mongodb.maxBatchSize"));
            maxBatch = 1000;
        }
        if (maxBatch > 10000) {
            this.getLogger().warn("graphdb.mongodb.maxBatchSize size is too large. Max allowed is 10000");
            maxBatch = 10000;
        }
        if (maxBatch == 0) {
            this.getLogger().info("MongoDB batch loading is disabled");
        }
        return maxBatch;
    }

    static class ContextImpl
    implements RequestContext {
        RequestCache cache = new RequestCache();
        Map<String, Object> map = new HashMap<String, Object>();
        Request request;
        LinkedList<MongoResultIterator> iters;
        Set<Long> contexts = new HashSet<Long>();
        Entities entities;
        long searchBNode;
        ContextPhase previousPhase = ContextPhase.INITIAL;
        ContextPhase phase = ContextPhase.INITIAL;

        ContextImpl() {
        }

        public Request getRequest() {
            return this.request;
        }

        public void setRequest(Request request) {
            this.request = request;
        }

        public Object getAttribute(String key) {
            return this.map.get(key);
        }

        public void setAttribute(String key, Object value) {
            this.map.put(key, value);
        }

        public void removeAttribute(String key) {
            this.map.remove(key);
        }

        public void addIterator(MongoResultIterator iter) {
            if (this.iters == null) {
                this.iters = new LinkedList();
            }
            this.iters.add(iter);
        }

        public void addContext(long ctx) {
            this.contexts.add(ctx);
        }

        public Set<Long> getContexts() {
            return this.contexts;
        }

        public void setPhase(ContextPhase phase) {
            this.previousPhase = this.phase;
            this.phase = phase;
        }
    }

    private static class LazyMongoResultIterator
    extends MongoResultIterator {
        private MongoResultIterator delegate;
        private final ContextImpl ctx;

        public LazyMongoResultIterator(long context, ContextImpl ctx) {
            super(null, null, null, null, null, 0L);
            this.ctx = ctx;
            super.setGraphId(context);
        }

        boolean isNotBound() {
            return this.getDelegate() == null;
        }

        @Override
        public boolean next() {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return false;
            }
            boolean hasNext = delegate.next();
            this.subject = delegate.subject;
            this.predicate = delegate.predicate;
            this.object = delegate.object;
            this.context = delegate.context;
            return hasNext;
        }

        @Override
        public StatementIterator getModelIterator(final long subjectM, final long predicateM, final long objectM) {
            this.setModelIteratorCreated(true);
            return new StatementIterator(){
                private StatementIterator modelIterator;

                public boolean next() {
                    if (this.modelIterator == null) {
                        MongoResultIterator delegate = this.getDelegate();
                        if (delegate == null) {
                            return false;
                        }
                        this.modelIterator = delegate.getModelIterator(subjectM, predicateM, objectM);
                    }
                    boolean hasNext = this.modelIterator.next();
                    this.subject = this.modelIterator.subject;
                    this.predicate = this.modelIterator.predicate;
                    this.object = this.modelIterator.object;
                    this.context = this.modelIterator.context;
                    return hasNext;
                }

                public void close() {
                    if (this.modelIterator != null) {
                        this.modelIterator.close();
                    }
                }
            };
        }

        MongoResultIterator getDelegate() {
            if (this.delegate == null) {
                long graphId = super.getGraphId();
                long searchSubject = super.getSearchSubject();
                this.delegate = this.getIterator(searchSubject, graphId, this.ctx);
            }
            return this.delegate;
        }

        private MongoResultIterator getIterator(long subject, long context, ContextImpl ctx) {
            MongoResultIterator curr;
            Iterator<MongoResultIterator> iter;
            if (subject != 0L) {
                for (MongoResultIterator it : ctx.iters) {
                    if (it instanceof LazyMongoResultIterator || it.getSearchSubject() != subject || this.isAlreadyDelegateToSomeoneElse(ctx, it)) continue;
                    return it;
                }
            }
            if (context != 0L) {
                iter = ctx.iters.descendingIterator();
                while (iter.hasNext()) {
                    curr = iter.next();
                    if (curr instanceof LazyMongoResultIterator || curr.getGraphId() != context || this.isAlreadyDelegateToSomeoneElse(ctx, curr)) continue;
                    return curr;
                }
            }
            iter = ctx.iters.descendingIterator();
            while (iter.hasNext()) {
                curr = iter.next();
                if (curr instanceof LazyMongoResultIterator || this.isAlreadyDelegateToSomeoneElse(ctx, curr)) continue;
                return curr;
            }
            return null;
        }

        private boolean isAlreadyDelegateToSomeoneElse(ContextImpl ctx, MongoResultIterator currentPick) {
            return ctx.iters.stream().anyMatch(it -> it instanceof LazyMongoResultIterator && ((LazyMongoResultIterator)it).delegate == currentPick);
        }

        @Override
        public void close() {
            super.close();
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        @Override
        public StatementIterator createEntityIter(long pred) {
            return this.getDelegate().createEntityIter(pred);
        }

        @Override
        public void setQuery(String query) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setQuery(query);
            }
            super.setQuery(query);
        }

        @Override
        public void setProjection(String projectionString) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setProjection(projectionString);
            }
            super.setProjection(projectionString);
        }

        @Override
        public void setAggregation(List<Document> aggregation) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setAggregation(aggregation);
            }
            super.setAggregation(aggregation);
        }

        @Override
        public void setGraphId(long graphId) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setGraphId(graphId);
            }
            super.setGraphId(graphId);
        }

        @Override
        public long getGraphId() {
            long graphId = super.getGraphId();
            if (graphId != 0L) {
                return graphId;
            }
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return this.getIndexId();
            }
            return delegate.getGraphId();
        }

        @Override
        public void setIndexId(long indexId) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setIndexId(indexId);
            }
            super.setIndexId(indexId);
        }

        @Override
        public void setDocumentsLimit(int documentsLimit) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setDocumentsLimit(documentsLimit);
            }
            super.setDocumentsLimit(documentsLimit);
        }

        @Override
        public int getDocumentsLimit() {
            int limit = super.getDocumentsLimit();
            if (limit != 0) {
                return limit;
            }
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return 0;
            }
            return delegate.getDocumentsLimit();
        }

        @Override
        public long getIndexId() {
            long indexId = super.getIndexId();
            if (indexId != 0L) {
                return indexId;
            }
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return 0L;
            }
            return delegate.getIndexId();
        }

        @Override
        public long getSearchSubject() {
            long searchSubject = super.getSearchSubject();
            if (searchSubject != 0L) {
                return searchSubject;
            }
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return 0L;
            }
            return delegate.getSearchSubject();
        }

        @Override
        public void setEntities(Entities entities) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                delegate.setEntities(entities);
            }
            super.setEntities(entities);
        }

        @Override
        public void setHint(String hintString) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setHint(hintString);
            }
            super.setHint(hintString);
        }

        @Override
        public void setCollation(String collationString) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                super.setCollation(collationString);
            } else {
                this.getDelegate().setCollation(collationString);
            }
        }

        @Override
        public Collation getCollation() {
            Collation collation = super.getCollation();
            if (collation != null) {
                return collation;
            }
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getCollation();
        }

        @Override
        public boolean isQuerySet() {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return super.isQuerySet();
            }
            return delegate.isQuerySet();
        }

        @Override
        public boolean isContextFirst() {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return super.isContextFirst();
            }
            return delegate.isContextFirst();
        }

        @Override
        public void setContextFirst(boolean contextFirst) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setContextFirst(contextFirst);
            }
            super.setContextFirst(contextFirst);
        }

        @Override
        public void setModelIteratorCreated(boolean modelIteratorCreated) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setModelIteratorCreated(modelIteratorCreated);
            }
            super.setModelIteratorCreated(modelIteratorCreated);
        }

        @Override
        public void setEntityIteratorCreated(boolean entityIteratorCreated) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                this.getDelegate().setEntityIteratorCreated(entityIteratorCreated);
            }
            super.setEntityIteratorCreated(entityIteratorCreated);
        }

        @Override
        public boolean isEntityIteratorCreated() {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return super.isEntityIteratorCreated();
            }
            return delegate.isEntityIteratorCreated();
        }

        @Override
        public boolean isModelIteratorCreated() {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return super.isModelIteratorCreated();
            }
            return delegate.isModelIteratorCreated();
        }

        @Override
        public String getQuery() {
            String query = super.getQuery();
            if (query != null) {
                return query;
            }
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getQuery();
        }

        @Override
        public String getProjection() {
            String projection = super.getProjection();
            if (projection != null) {
                return projection;
            }
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getProjection();
        }

        @Override
        public String getHint() {
            String hint = super.getHint();
            if (hint != null) {
                return hint;
            }
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getHint();
        }

        @Override
        public void setCollation(Collation collation) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                delegate.setCollation(collation);
            }
            super.setCollation(collation);
        }

        @Override
        public List<Document> getAggregation() {
            List<Document> aggregation = super.getAggregation();
            if (aggregation != null) {
                return aggregation;
            }
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getAggregation();
        }

        @Override
        public boolean isClosed() {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return super.isClosed();
            }
            return delegate.isClosed();
        }

        @Override
        public boolean isCloned() {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate == null) {
                return super.isCloned();
            }
            return delegate.isCloned();
        }

        @Override
        public void setCloned(boolean cloned) {
            MongoResultIterator delegate = this.getDelegate();
            if (delegate != null) {
                delegate.setCloned(cloned);
            }
            super.setCloned(cloned);
        }
    }

    static enum ContextPhase {
        INITIAL,
        SEARCH_DEFINITION,
        MODEL_ITERATION;

    }
}

