/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.splitter.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.normalization.DistinctNormalizer;
import it.unibz.inf.ontop.iq.optimizer.splitter.PreventDistinctProjectionSplitter;
import it.unibz.inf.ontop.iq.optimizer.splitter.ProjectionSplitter;
import it.unibz.inf.ontop.iq.optimizer.splitter.impl.ProjectionSplitterImpl;
import it.unibz.inf.ontop.iq.tools.ProjectionDecomposer;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.IntStream;

public class PreventDistinctProjectionSplitterImpl
extends ProjectionSplitterImpl
implements PreventDistinctProjectionSplitter {
    private final ProjectionDecomposer decomposer;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private PreventDistinctProjectionSplitterImpl(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, CoreUtilsFactory coreUtilsFactory, DistinctNormalizer distinctNormalizer) {
        super(iqFactory, substitutionFactory, distinctNormalizer);
        this.decomposer = coreUtilsFactory.createProjectionDecomposer(t -> !PreventDistinctProjectionSplitterImpl.shouldSplit(t), n -> true);
        this.iqFactory = iqFactory;
    }

    @Override
    public ProjectionSplitter.ProjectionSplit split(IQTree tree, VariableGenerator variableGenerator) {
        return this.split(tree, variableGenerator, this.decomposer);
    }

    private static boolean shouldSplit(ImmutableFunctionalTerm term) {
        return term.getTerms().stream().anyMatch(PreventDistinctProjectionSplitterImpl::shouldPreventDistinct) || IntStream.range(0, term.getArity()).mapToObj(i -> term.getFunctionSymbol().getExpectedBaseType(i)).filter(t -> t instanceof DBTermType).anyMatch(t -> ((DBTermType)t).isPreventDistinctRecommended());
    }

    private static boolean shouldPreventDistinct(ImmutableTerm term) {
        Optional type = term.inferType();
        return type.flatMap(TermTypeInference::getTermType).filter(t -> t instanceof DBTermType).map(t -> (DBTermType)t).map(DBTermType::isPreventDistinctRecommended).orElse(false);
    }

    @Override
    protected IQTree insertConstructionNode(IQTree tree, ConstructionNode constructionNode, VariableGenerator variableGenerator) {
        QueryNode rootNode = tree.getRootNode();
        if (!(rootNode instanceof DistinctNode)) {
            return super.insertConstructionNode(tree, constructionNode, variableGenerator);
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)((DistinctNode)rootNode), (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, ((UnaryIQTree)tree).getChild()));
    }
}

