/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RequiredExtensionalDataNodeExtractor {
    @Inject
    protected RequiredExtensionalDataNodeExtractor() {
    }

    public Stream<ExtensionalDataNode> extractSomeRequiredNodes(IQTree tree, boolean fromLeft) {
        QueryNode root = tree.getRootNode();
        if (tree instanceof ExtensionalDataNode) {
            return Stream.of((ExtensionalDataNode)tree);
        }
        if (root instanceof InnerJoinNode) {
            return tree.getChildren().stream().flatMap(tree1 -> this.extractSomeRequiredNodes((IQTree)tree1, fromLeft));
        }
        if (fromLeft && root instanceof LeftJoinNode) {
            return this.extractSomeRequiredNodes(((BinaryNonCommutativeIQTree)tree).getLeftChild(), true);
        }
        if (!fromLeft && root instanceof ConstructionNode && ((ConstructionNode)root).getSubstitution().rangeAllMatch(ImmutableTerm::isGround)) {
            return this.extractSomeRequiredNodes(((UnaryIQTree)tree).getChild(), false);
        }
        return this.extractOtherType(tree);
    }

    protected Stream<ExtensionalDataNode> extractOtherType(IQTree tree) {
        return Stream.empty();
    }
}

