/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.LookForDistinctOrLimit1TransformerImpl;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.AbstractLJTransformer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.RequiredExtensionalDataNodeExtractor;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultNonRecursiveIQTreeTransformer;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Singleton
public class NullableFDSelfLJOptimizer
implements LeftJoinIQOptimizer {
    private final RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor;
    private final RightProvenanceNormalizer rightProvenanceNormalizer;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected NullableFDSelfLJOptimizer(RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreSingletons coreSingletons) {
        this.requiredDataNodeExtractor = requiredDataNodeExtractor;
        this.rightProvenanceNormalizer = rightProvenanceNormalizer;
        this.variableNullabilityTools = variableNullabilityTools;
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public IQ optimize(IQ query) {
        LookForDistinctOrLimit1TransformerImpl transformer;
        IQTree initialTree = query.getTree();
        IQTree newTree = initialTree.acceptTransformer((IQTreeVisitingTransformer)(transformer = new LookForDistinctOrLimit1TransformerImpl((childTree, parentTransformer) -> new CardinalityInsensitiveTransformer(parentTransformer, () -> ((IQTree)childTree).getVariableNullability(), query.getVariableGenerator(), this.requiredDataNodeExtractor, this.rightProvenanceNormalizer, this.variableNullabilityTools, this.coreSingletons), this.coreSingletons)));
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected static class DataNodeAndProvenanceVariables {
        public final ExtensionalDataNode dataNode;
        public final ImmutableSet<Variable> provenanceVariables;

        protected DataNodeAndProvenanceVariables(ExtensionalDataNode dataNode, ImmutableSet<Variable> provenanceVariables) {
            this.dataNode = dataNode;
            this.provenanceVariables = provenanceVariables;
        }
    }

    private static class DataNodeOnLeftReplacer
    extends DefaultNonRecursiveIQTreeTransformer {
        private final IntermediateQueryFactory iqFactory;
        private final ExtensionalDataNode nodeToBeReplaced;
        private final ExtensionalDataNode replacingNode;
        private boolean found;

        protected DataNodeOnLeftReplacer(IntermediateQueryFactory iqFactory, ExtensionalDataNode nodeToBeReplaced, ExtensionalDataNode replacingNode) {
            this.iqFactory = iqFactory;
            this.nodeToBeReplaced = nodeToBeReplaced;
            this.replacingNode = replacingNode;
            this.found = false;
        }

        public boolean hasBeenReplaced() {
            return this.found;
        }

        public IQTree transformExtensionalData(ExtensionalDataNode dataNode) {
            if (!this.found && dataNode.equals(this.nodeToBeReplaced)) {
                this.found = true;
                return this.replacingNode;
            }
            return dataNode;
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            if (this.found) {
                return tree;
            }
            IQTree newLeft = this.transform(leftChild);
            return newLeft.equals(leftChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, newLeft, rightChild);
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            if (this.found) {
                return tree;
            }
            ImmutableList newChildren = (ImmutableList)children.stream().map(arg_0 -> ((DataNodeOnLeftReplacer)this).transform(arg_0)).collect(ImmutableCollectors.toList());
            return newChildren.equals(children) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren);
        }
    }

    private static class Transfer {
        private final ExtensionalDataNode leftNode;
        private final ImmutableSet<Variable> determinantVariables;
        private final ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentsToTransfer;

        protected Transfer(ExtensionalDataNode leftNode, ImmutableSet<Variable> determinantVariables, ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentsToTransfer) {
            this.leftNode = leftNode;
            this.determinantVariables = determinantVariables;
            this.argumentsToTransfer = argumentsToTransfer;
        }

        public ExtensionalDataNode generateNewLeftNode(VariableGenerator variableGenerator, IntermediateQueryFactory iqFactory) {
            ImmutableMap leftArgumentMap = this.leftNode.getArgumentMap();
            ImmutableMap newArgumentMap = (ImmutableMap)Sets.union((Set)leftArgumentMap.keySet(), (Set)this.argumentsToTransfer.keySet()).stream().collect(ImmutableCollectors.toMap(i -> i, i -> Optional.ofNullable((VariableOrGroundTerm)leftArgumentMap.get(i)).orElseGet(() -> (VariableOrGroundTerm)Optional.ofNullable((VariableOrGroundTerm)this.argumentsToTransfer.get(i)).filter(t -> t instanceof Variable).map(v -> variableGenerator.generateNewVariableFromVar((Variable)v)).orElseGet(() -> ((VariableGenerator)variableGenerator).generateNewVariable()))));
            return iqFactory.createExtensionalDataNode(this.leftNode.getRelationDefinition(), newArgumentMap);
        }
    }

    protected static class CardinalityInsensitiveTransformer
    extends AbstractLJTransformer {
        private final IQTreeTransformer lookForDistinctTransformer;
        private final RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor;
        private final DBConstant provenanceConstant;

        protected CardinalityInsensitiveTransformer(IQTreeTransformer lookForDistinctTransformer, Supplier<VariableNullability> variableNullabilitySupplier, VariableGenerator variableGenerator, RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreSingletons coreSingletons) {
            super(variableNullabilitySupplier, variableGenerator, rightProvenanceNormalizer, variableNullabilityTools, coreSingletons);
            this.lookForDistinctTransformer = lookForDistinctTransformer;
            this.requiredDataNodeExtractor = requiredDataNodeExtractor;
            this.provenanceConstant = this.termFactory.getProvenanceSpecialConstant();
        }

        @Override
        protected Optional<IQTree> furtherTransformLeftJoin(LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            Optional<DataNodeAndProvenanceVariables> dataNodeAndProvenanceVariables = this.extractDataNodeAndProvenance(rightChild);
            if (dataNodeAndProvenanceVariables.isEmpty()) {
                return Optional.empty();
            }
            ExtensionalDataNode rightNode = dataNodeAndProvenanceVariables.get().dataNode;
            ImmutableSet<Variable> provenanceVariables = dataNodeAndProvenanceVariables.get().provenanceVariables;
            ImmutableMap rightArgumentMap = rightNode.getArgumentMap();
            ImmutableList nullableCoveringFDs = (ImmutableList)rightNode.getRelationDefinition().getOtherFunctionalDependencies().stream().filter(fd -> fd.getDeterminants().stream().anyMatch(Attribute::isNullable)).filter(fd -> ((ImmutableSet)Sets.union((Set)fd.getDeterminants(), (Set)fd.getDependents()).stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet())).containsAll((Collection)rightArgumentMap.keySet())).collect(ImmutableCollectors.toList());
            Optional transfer = this.requiredDataNodeExtractor.extractSomeRequiredNodes(leftChild, true).flatMap(left -> this.tryToTransfer((ExtensionalDataNode)left, rightNode, (ImmutableList<FunctionalDependency>)nullableCoveringFDs).stream()).findAny();
            return transfer.map(t -> this.updateLeftTree((Transfer)t, leftChild, rootNode.getOptionalFilterCondition(), provenanceVariables));
        }

        private Optional<DataNodeAndProvenanceVariables> extractDataNodeAndProvenance(IQTree rightChild) {
            if (rightChild instanceof ExtensionalDataNode) {
                return Optional.of(new DataNodeAndProvenanceVariables((ExtensionalDataNode)rightChild, (ImmutableSet<Variable>)ImmutableSet.of()));
            }
            if (rightChild.getRootNode() instanceof ConstructionNode) {
                Substitution substitution = ((ConstructionNode)rightChild.getRootNode()).getSubstitution();
                IQTree subChild = (IQTree)rightChild.getChildren().get(0);
                if (subChild instanceof ExtensionalDataNode && substitution.rangeAllMatch(t -> t.equals(this.provenanceConstant))) {
                    return Optional.of(new DataNodeAndProvenanceVariables((ExtensionalDataNode)subChild, (ImmutableSet<Variable>)substitution.getDomain()));
                }
            }
            return Optional.empty();
        }

        private Optional<Transfer> tryToTransfer(ExtensionalDataNode leftNode, ExtensionalDataNode rightNode, ImmutableList<FunctionalDependency> coveringFDs) {
            if (!leftNode.getRelationDefinition().equals(rightNode.getRelationDefinition())) {
                return Optional.empty();
            }
            ImmutableMap leftArgumentMap = leftNode.getArgumentMap();
            ImmutableMap rightArgumentMap = rightNode.getArgumentMap();
            ImmutableMap commonArgumentMap = (ImmutableMap)Sets.intersection((Set)leftArgumentMap.entrySet(), (Set)rightArgumentMap.entrySet()).stream().collect(ImmutableCollectors.toMap());
            if (commonArgumentMap.isEmpty()) {
                return Optional.empty();
            }
            Optional<FunctionalDependency> selectedFD = coveringFDs.stream().filter(fd -> fd.getDeterminants().stream().allMatch(a -> commonArgumentMap.containsKey((Object)(a.getIndex() - 1)))).findAny();
            Optional<Transfer> fdTransfer = selectedFD.map(fd -> {
                ImmutableSet dependentIndexes = (ImmutableSet)fd.getDependents().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
                ImmutableSet determinantVariables = (ImmutableSet)fd.getDeterminants().stream().map(a -> (VariableOrGroundTerm)commonArgumentMap.get((Object)(a.getIndex() - 1))).filter(t -> t instanceof Variable).map(v -> (Variable)v).collect(ImmutableCollectors.toSet());
                return new Transfer(leftNode, (ImmutableSet<Variable>)determinantVariables, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)((ImmutableMap)rightArgumentMap.entrySet().stream().filter(e -> dependentIndexes.contains(e.getKey())).collect(ImmutableCollectors.toMap())));
            });
            if (fdTransfer.isPresent()) {
                return fdTransfer;
            }
            if (rightArgumentMap.equals((Object)commonArgumentMap)) {
                ImmutableSet determinantVariables = (ImmutableSet)commonArgumentMap.values().stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toSet());
                return Optional.of(new Transfer(leftNode, (ImmutableSet<Variable>)determinantVariables, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)ImmutableMap.of()));
            }
            return Optional.empty();
        }

        private IQTree updateLeftTree(Transfer transfer, IQTree leftChild, Optional<ImmutableExpression> optionalFilterCondition, ImmutableSet<Variable> provenanceVariables) {
            ExtensionalDataNode newLeftNode = transfer.generateNewLeftNode(this.variableGenerator, this.iqFactory);
            ImmutableSet leftVariables = leftChild.getVariables();
            ImmutableExpression condition = this.computeRightTermCondition(newLeftNode, (ImmutableSet<Variable>)leftVariables, transfer.determinantVariables, transfer.argumentsToTransfer, optionalFilterCondition);
            Substitution<? extends ImmutableTerm> substitution = this.computeSubstitution(condition, (ImmutableSet<Variable>)leftVariables, transfer.argumentsToTransfer, newLeftNode, provenanceVariables);
            IQTree newLeftTree = this.replaceNodeOnLeft(leftChild, transfer.leftNode, newLeftNode);
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(Sets.union((Set)leftVariables, (Set)substitution.getDomain()).immutableCopy(), substitution), newLeftTree);
        }

        private ImmutableExpression computeRightTermCondition(ExtensionalDataNode newLeftNode, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> determinantVariables, ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentsToTransfer, Optional<ImmutableExpression> optionalFilterCondition) {
            ImmutableMap leftArgumentMap = newLeftNode.getArgumentMap();
            Stream<ImmutableExpression> groundTermsAndImplicitEqualitiesWithLeft = argumentsToTransfer.entrySet().stream().filter(e -> ((VariableOrGroundTerm)e.getValue()).isGround() || leftVariables.contains((Object)((Variable)e.getValue()))).map(e -> this.termFactory.getStrictEquality((ImmutableTerm)leftArgumentMap.get(e.getKey()), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]));
            ImmutableMap inverseVariableMap = ((ImmutableMultimap)argumentsToTransfer.entrySet().stream().filter(e -> e.getValue() instanceof Variable).collect(ImmutableCollectors.toMultimap(e -> (Variable)e.getValue(), Map.Entry::getKey))).asMap();
            Stream coOccurrenceEqualities = inverseVariableMap.values().stream().flatMap(indexes -> {
                VariableOrGroundTerm firstTerm = (VariableOrGroundTerm)leftArgumentMap.get(indexes.iterator().next());
                return indexes.stream().skip(1L).map(i -> this.termFactory.getStrictEquality((ImmutableTerm)firstTerm, (ImmutableTerm)leftArgumentMap.get(i), new ImmutableTerm[0]));
            });
            return (ImmutableExpression)this.termFactory.getConjunction(optionalFilterCondition, Stream.concat(Stream.concat(determinantVariables.stream().map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)), groundTermsAndImplicitEqualitiesWithLeft), coOccurrenceEqualities)).orElseThrow(() -> new MinorOntopInternalBugException("At least one determinant was expected"));
        }

        private Substitution<? extends ImmutableTerm> computeSubstitution(ImmutableExpression condition, ImmutableSet<Variable> leftVariables, ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentsToTransfer, ExtensionalDataNode newLeftNode, ImmutableSet<Variable> provenanceVariables) {
            ImmutableMap leftArgumentMap = newLeftNode.getArgumentMap();
            Substitution argSubstitution = (Substitution)argumentsToTransfer.asMultimap().inverse().asMap().entrySet().stream().filter(e -> e.getKey() instanceof Variable).filter(e -> !leftVariables.contains((Object)((Variable)e.getKey()))).collect(this.substitutionFactory.toSubstitution(e -> (Variable)e.getKey(), e -> this.termFactory.getIfElseNull(condition, (ImmutableTerm)leftArgumentMap.get(((Collection)e.getValue()).iterator().next()))));
            if (provenanceVariables.isEmpty()) {
                return argSubstitution;
            }
            Substitution provSubstitution = (Substitution)provenanceVariables.stream().collect(this.substitutionFactory.toSubstitution(t -> this.termFactory.getIfElseNull(condition, (ImmutableTerm)this.provenanceConstant)));
            return argSubstitution.compose(provSubstitution);
        }

        private IQTree replaceNodeOnLeft(IQTree leftChild, ExtensionalDataNode leftNode, ExtensionalDataNode newLeftNode) {
            if (leftChild.equals(leftNode)) {
                return newLeftNode;
            }
            if (leftNode.equals(newLeftNode)) {
                return leftChild;
            }
            DataNodeOnLeftReplacer replacer = new DataNodeOnLeftReplacer(this.iqFactory, leftNode, newLeftNode);
            IQTree newLeft = replacer.transform(leftChild);
            if (!replacer.hasBeenReplaced()) {
                throw new MinorOntopInternalBugException(String.format("Could not replace %s on the left", leftNode));
            }
            return newLeft;
        }

        @Override
        protected IQTree transformBySearchingFromScratch(IQTree tree) {
            return this.lookForDistinctTransformer.transform(tree);
        }

        @Override
        protected IQTree preTransformLJRightChild(IQTree rightChild, Optional<ImmutableExpression> ljCondition, ImmutableSet<Variable> leftVariables) {
            CardinalityInsensitiveTransformer newTransformer = new CardinalityInsensitiveTransformer(this.lookForDistinctTransformer, () -> ((IQTree)rightChild).getVariableNullability(), this.variableGenerator, this.requiredDataNodeExtractor, this.rightProvenanceNormalizer, this.variableNullabilityTools, this.coreSingletons);
            return rightChild.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        }
    }
}

