/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.AbstractLJTransformer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.CardinalitySensitiveJoinTransferLJOptimizer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Singleton
public class LJWithNestingOnRightToInnerJoinOptimizer
implements LeftJoinIQOptimizer {
    private final RightProvenanceNormalizer rightProvenanceNormalizer;
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final CardinalitySensitiveJoinTransferLJOptimizer otherLJOptimizer;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;

    @Inject
    protected LJWithNestingOnRightToInnerJoinOptimizer(RightProvenanceNormalizer rightProvenanceNormalizer, CoreSingletons coreSingletons, CardinalitySensitiveJoinTransferLJOptimizer otherLJOptimizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools) {
        this.rightProvenanceNormalizer = rightProvenanceNormalizer;
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
        this.otherLJOptimizer = otherLJOptimizer;
        this.variableNullabilityTools = variableNullabilityTools;
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        Transformer transformer = new Transformer(() -> ((IQTree)initialTree).getVariableNullability(), query.getVariableGenerator(), this.rightProvenanceNormalizer, this.coreSingletons, this.otherLJOptimizer, this.variableNullabilityTools);
        IQTree newTree = initialTree.acceptTransformer((IQTreeVisitingTransformer)transformer);
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected static class Transformer
    extends AbstractLJTransformer {
        private final CardinalitySensitiveJoinTransferLJOptimizer otherLJOptimizer;
        private final AtomFactory atomFactory;

        protected Transformer(Supplier<VariableNullability> variableNullabilitySupplier, VariableGenerator variableGenerator, RightProvenanceNormalizer rightProvenanceNormalizer, CoreSingletons coreSingletons, CardinalitySensitiveJoinTransferLJOptimizer otherLJOptimizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools) {
            super(variableNullabilitySupplier, variableGenerator, rightProvenanceNormalizer, variableNullabilityTools, coreSingletons);
            this.otherLJOptimizer = otherLJOptimizer;
            this.atomFactory = coreSingletons.getAtomFactory();
        }

        @Override
        protected Optional<IQTree> furtherTransformLeftJoin(LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            Optional<ConstructionNode> rightConstructionNode = Optional.of(rightChild.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n);
            Optional<BinaryNonCommutativeIQTree> rightLJ = rightConstructionNode.map(c -> (IQTree)rightChild.getChildren().get(0)).or(() -> Optional.of(rightChild)).filter(t -> t.getRootNode() instanceof LeftJoinNode).map(t -> (BinaryNonCommutativeIQTree)t);
            return rightLJ.flatMap(rLJ -> this.tryToSimplify(leftChild, rightChild, rootNode.getOptionalFilterCondition(), (BinaryNonCommutativeIQTree)rLJ));
        }

        @Override
        protected IQTree transformBySearchingFromScratch(IQTree tree) {
            Transformer newTransformer = new Transformer(() -> ((IQTree)tree).getVariableNullability(), this.variableGenerator, this.rightProvenanceNormalizer, this.coreSingletons, this.otherLJOptimizer, this.variableNullabilityTools);
            return tree.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        }

        @Override
        protected IQTree preTransformLJRightChild(IQTree rightChild, Optional<ImmutableExpression> ljCondition, ImmutableSet<Variable> leftVariables) {
            Supplier<VariableNullability> variableNullabilitySupplier = () -> this.computeRightChildVariableNullability(rightChild, ljCondition);
            Transformer newTransformer = new Transformer(variableNullabilitySupplier, this.variableGenerator, this.rightProvenanceNormalizer, this.coreSingletons, this.otherLJOptimizer, this.variableNullabilityTools);
            return rightChild.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        }

        private Optional<IQTree> tryToSimplify(IQTree leftChild, IQTree rightChild, Optional<ImmutableExpression> leftJoinCondition, BinaryNonCommutativeIQTree rightLJ) {
            Sets.SetView commonVariables = Sets.intersection((Set)leftChild.getVariables(), (Set)rightChild.getVariables());
            if (!rightLJ.getVariables().containsAll((Collection)commonVariables)) {
                return Optional.empty();
            }
            if (leftJoinCondition.isPresent()) {
                if (rightChild.inferUniqueConstraints().stream().noneMatch(((Set)commonVariables)::containsAll)) {
                    return Optional.empty();
                }
            }
            Optional<IQTree> safeLeftOfRightDescendant = this.extractSafeLeftOfRightDescendantTree(rightLJ.getLeftChild(), (Set<Variable>)commonVariables);
            return safeLeftOfRightDescendant.filter(r -> this.canLJBeReduced(leftChild, (IQTree)r)).map(r -> this.buildInnerJoin(leftChild, rightChild, leftJoinCondition)).map(t -> t.normalizeForOptimization(this.variableGenerator));
        }

        private boolean canLJBeReduced(IQTree leftChild, IQTree safeLeftOfRightDescendant) {
            ImmutableSet leftChildVariables = leftChild.getVariables();
            RightProvenanceNormalizer.RightProvenance rightProvenance = this.rightProvenanceNormalizer.normalizeRightProvenance(safeLeftOfRightDescendant, leftChildVariables, Optional.empty(), this.variableGenerator);
            VariableNullability inheritedVariableNullability = this.getInheritedVariableNullability();
            Optional nonNullabilityCondition = this.termFactory.getConjunction(leftChildVariables.stream().filter(v -> !inheritedVariableNullability.isPossiblyNullable(v)).map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)));
            ImmutableExpression isNullCondition = this.termFactory.getDBIsNull((ImmutableTerm)rightProvenance.getProvenanceVariable());
            ImmutableExpression filterCondition = nonNullabilityCondition.map(c -> this.termFactory.getConjunction(isNullCondition, new ImmutableExpression[]{c})).orElse(isNullCondition);
            UnaryIQTree minusTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(filterCondition), (IQTree)this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this.iqFactory.createLeftJoinNode(), leftChild, rightProvenance.getRightTree()));
            ConstructionNode constructionNode = this.iqFactory.createConstructionNode(ImmutableSet.of((Object)rightProvenance.getProvenanceVariable()));
            DistinctVariableOnlyDataAtom minusFakeProjectionAtom = this.atomFactory.getDistinctVariableOnlyDataAtom(this.atomFactory.getRDFAnswerPredicate(1), ImmutableList.copyOf((Collection)constructionNode.getVariables()));
            return this.otherLJOptimizer.optimize(this.iqFactory.createIQ(minusFakeProjectionAtom, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, (IQTree)minusTree))).normalizeForOptimization().getTree().isDeclaredAsEmpty();
        }

        private Optional<IQTree> extractSafeLeftOfRightDescendantTree(IQTree leftChild, Set<Variable> rightVariablesInteractingWithLeft) {
            if (!leftChild.getVariables().containsAll(rightVariablesInteractingWithLeft)) {
                return Optional.empty();
            }
            QueryNode rootNode = leftChild.getRootNode();
            if (rootNode instanceof LeftJoinNode) {
                return this.extractSafeLeftOfRightDescendantTree((IQTree)leftChild.getChildren().get(0), rightVariablesInteractingWithLeft);
            }
            return Optional.of(leftChild);
        }

        private IQTree buildInnerJoin(IQTree leftChild, IQTree rightChild, Optional<ImmutableExpression> leftJoinCondition) {
            NaryIQTree joinTree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), ImmutableList.of((Object)leftChild, (Object)rightChild));
            if (leftJoinCondition.isEmpty()) {
                return joinTree;
            }
            InjectiveSubstitution renaming = (InjectiveSubstitution)Sets.difference((Set)rightChild.getVariables(), (Set)leftChild.getVariables()).stream().collect(this.substitutionFactory.toFreshRenamingSubstitution(this.variableGenerator));
            ImmutableExpression renamedCondition = renaming.apply(leftJoinCondition.get());
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(joinTree.getVariables(), renaming.builder().transform(t -> this.termFactory.getIfElseNull(renamedCondition, (ImmutableTerm)t)).build()), joinTree.applyFreshRenaming(renaming));
        }
    }
}

