/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultNonRecursiveIQTreeTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractLJTransformer
extends DefaultNonRecursiveIQTreeTransformer {
    private final Supplier<VariableNullability> variableNullabilitySupplier;
    private VariableNullability variableNullability;
    protected final VariableGenerator variableGenerator;
    protected final RightProvenanceNormalizer rightProvenanceNormalizer;
    protected final CoreSingletons coreSingletons;
    protected final IntermediateQueryFactory iqFactory;
    protected final TermFactory termFactory;
    protected final SubstitutionFactory substitutionFactory;
    protected final JoinOrFilterVariableNullabilityTools variableNullabilityTools;

    protected AbstractLJTransformer(Supplier<VariableNullability> variableNullabilitySupplier, VariableGenerator variableGenerator, RightProvenanceNormalizer rightProvenanceNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreSingletons coreSingletons) {
        this.variableNullabilitySupplier = variableNullabilitySupplier;
        this.variableGenerator = variableGenerator;
        this.rightProvenanceNormalizer = rightProvenanceNormalizer;
        this.variableNullabilityTools = variableNullabilityTools;
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
        this.termFactory = coreSingletons.getTermFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
    }

    public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        IQTree transformedLeftChild = this.transform(leftChild);
        IQTree transformedRightChild = this.preTransformLJRightChild(rightChild, rootNode.getOptionalFilterCondition(), (ImmutableSet<Variable>)leftChild.getVariables());
        if (this.preventRecursiveOptimizationOnRightChild() && !transformedRightChild.equals(rightChild)) {
            return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, transformedLeftChild, transformedRightChild).normalizeForOptimization(this.variableGenerator);
        }
        return this.furtherTransformLeftJoin(rootNode, transformedLeftChild, transformedRightChild).orElseGet(() -> transformedLeftChild.equals(leftChild) && transformedRightChild.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, transformedLeftChild, transformedRightChild)).normalizeForOptimization(this.variableGenerator);
    }

    protected boolean preventRecursiveOptimizationOnRightChild() {
        return false;
    }

    protected abstract Optional<IQTree> furtherTransformLeftJoin(LeftJoinNode var1, IQTree var2, IQTree var3);

    protected synchronized VariableNullability getInheritedVariableNullability() {
        if (this.variableNullability == null) {
            this.variableNullability = this.variableNullabilitySupplier.get();
        }
        return this.variableNullability;
    }

    public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
        return this.transformUnaryNode(tree, (UnaryOperatorNode)rootNode, child, arg_0 -> ((AbstractLJTransformer)this).transform(arg_0));
    }

    public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child) {
        return this.transformUnaryNode(tree, (UnaryOperatorNode)rootNode, child, arg_0 -> ((AbstractLJTransformer)this).transform(arg_0));
    }

    public IQTree transformSlice(IQTree tree, SliceNode sliceNode, IQTree child) {
        return this.transformUnaryNode(tree, (UnaryOperatorNode)sliceNode, child, arg_0 -> ((AbstractLJTransformer)this).transform(arg_0));
    }

    public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
        return this.transformUnaryNode(tree, (UnaryOperatorNode)rootNode, child, arg_0 -> ((AbstractLJTransformer)this).transform(arg_0));
    }

    public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        return this.transformNaryCommutativeNode(tree, (NaryOperatorNode)rootNode, children, arg_0 -> ((AbstractLJTransformer)this).transform(arg_0));
    }

    protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
        return this.transformUnaryNode(tree, rootNode, child, this::transformBySearchingFromScratch);
    }

    protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child, Function<IQTree, IQTree> childTransformation) {
        IQTree newChild = childTransformation.apply(child);
        return newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree(rootNode, newChild).normalizeForOptimization(this.variableGenerator);
    }

    protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
        return this.transformNaryCommutativeNode(tree, rootNode, children, this::transformBySearchingFromScratch);
    }

    protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children, Function<IQTree, IQTree> childTransformation) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(childTransformation).collect(ImmutableCollectors.toList());
        return newChildren.equals(children) ? tree : this.iqFactory.createNaryIQTree(rootNode, newChildren).normalizeForOptimization(this.variableGenerator);
    }

    protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
        return this.transformBinaryNonCommutativeNode(tree, rootNode, leftChild, rightChild, this::transformBySearchingFromScratch);
    }

    protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild, Function<IQTree, IQTree> childTransformation) {
        IQTree newLeftChild = childTransformation.apply(leftChild);
        IQTree newRightChild = childTransformation.apply(rightChild);
        return newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree(rootNode, newLeftChild, newRightChild).normalizeForOptimization(this.variableGenerator);
    }

    protected abstract IQTree transformBySearchingFromScratch(IQTree var1);

    protected abstract IQTree preTransformLJRightChild(IQTree var1, Optional<ImmutableExpression> var2, ImmutableSet<Variable> var3);

    protected VariableNullability computeRightChildVariableNullability(IQTree rightChild, Optional<ImmutableExpression> ljCondition) {
        VariableNullability bottomUpNullability = rightChild.getVariableNullability();
        VariableNullability nullabilityWithLJCondition = ljCondition.map(c -> this.variableNullabilityTools.updateWithFilter(c, bottomUpNullability.getNullableGroups(), rightChild.getVariables())).orElse(bottomUpNullability);
        ImmutableSet nullableVariablesAfterLJCondition = nullabilityWithLJCondition.getNullableVariables();
        if (nullableVariablesAfterLJCondition.isEmpty()) {
            return nullabilityWithLJCondition;
        }
        VariableNullability inheritedNullability = this.getInheritedVariableNullability();
        Optional additionalFilter = this.termFactory.getConjunction(nullableVariablesAfterLJCondition.stream().filter(v -> !inheritedNullability.isPossiblyNullable(v)).map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)));
        return additionalFilter.map(c -> this.variableNullabilityTools.updateWithFilter(c, nullabilityWithLJCondition.getNullableGroups(), rightChild.getVariables())).orElse(nullabilityWithLJCondition);
    }

    protected Supplier<VariableNullability> computeChildVariableNullabilityFromConstructionParent(IQTree tree, ConstructionNode rootNode, IQTree child) {
        ImmutableSet childVariables = child.getVariables();
        VariableNullability inheritedVariableNullability = this.getInheritedVariableNullability();
        VariableNullability bottomUpVariableNullability = tree.getVariableNullability();
        Optional isNotNullConditions = this.termFactory.getConjunction(childVariables.stream().filter(v -> !rootNode.getSubstitution().isDefining(v)).filter(arg_0 -> ((VariableNullability)bottomUpVariableNullability).isPossiblyNullable(arg_0)).filter(v -> !inheritedVariableNullability.isPossiblyNullable(v)).map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)));
        return () -> isNotNullConditions.map(c -> this.variableNullabilityTools.updateWithFilter(c, child.getVariableNullability().getNullableGroups(), childVariables)).orElseGet(() -> ((IQTree)child).getVariableNullability());
    }
}

