/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.optimizer.DisjunctionOfEqualitiesMergingSimplifier;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.iq.type.impl.AbstractExpressionTransformer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBAndFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBInFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBOrFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DisjunctionOfEqualitiesMergingSimplifierImpl
implements DisjunctionOfEqualitiesMergingSimplifier {
    private final CoreSingletons coreSingletons;
    private static final int MAX_ARITY = 8;

    @Inject
    protected DisjunctionOfEqualitiesMergingSimplifierImpl(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree tree = query.getTree();
        InCreatingTransformer transformer1 = new InCreatingTransformer(this.coreSingletons.getIQFactory(), this.coreSingletons.getUniqueTermTypeExtractor(), this.coreSingletons.getTermFactory());
        IQTree newTree = transformer1.transform(tree);
        InMergingTransformer transformer2 = new InMergingTransformer(this.coreSingletons.getIQFactory(), this.coreSingletons.getUniqueTermTypeExtractor(), this.coreSingletons.getTermFactory());
        IQTree finalTree = transformer2.transform(newTree);
        return finalTree == tree ? query : this.coreSingletons.getIQFactory().createIQ(query.getProjectionAtom(), finalTree).normalizeForOptimization();
    }

    private static boolean isConvertableEquality(ImmutableTerm term) {
        return Optional.of(term).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol).filter(t -> t.getArity() == 2).filter(t -> t.getTerms().stream().noneMatch(ImmutableTerm::isNull)).filter(t -> t.getTerms().stream().filter(child -> child instanceof Constant).count() == 1L).isPresent();
    }

    private static Optional<ImmutableFunctionalTerm> convertSingleEqualities(ImmutableTerm term, TermFactory termFactory) {
        if (!DisjunctionOfEqualitiesMergingSimplifierImpl.isConvertableEquality(term)) {
            return Optional.empty();
        }
        ImmutableFunctionalTerm f = (ImmutableFunctionalTerm)term;
        return Optional.of(termFactory.getImmutableExpression((BooleanFunctionSymbol)termFactory.getDBFunctionSymbolFactory().getStrictDBIn(2), new ImmutableTerm[]{f.getTerm(0) instanceof Constant ? f.getTerm(1) : f.getTerm(0), f.getTerm(1) instanceof Constant ? f.getTerm(1) : f.getTerm(0)}));
    }

    protected static class InMergingTransformer
    extends AbstractExpressionTransformer {
        protected InMergingTransformer(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
            super(iqFactory, typeExtractor, termFactory);
        }

        protected boolean isFunctionSymbolToReplace(FunctionSymbol functionSymbol) {
            return functionSymbol instanceof DBAndFunctionSymbol || functionSymbol instanceof DBOrFunctionSymbol;
        }

        private static boolean isBooleanOperation(ImmutableTerm term) {
            if (!(term instanceof ImmutableFunctionalTerm)) {
                return false;
            }
            ImmutableFunctionalTerm f = (ImmutableFunctionalTerm)term;
            return f.getFunctionSymbol() instanceof DBAndFunctionSymbol || f.getFunctionSymbol() instanceof DBOrFunctionSymbol;
        }

        private BooleanFunctionSymbol operatorSymbol(int arity, boolean conjunction) {
            return conjunction ? this.termFactory.getDBFunctionSymbolFactory().getDBAnd(arity) : this.termFactory.getDBFunctionSymbolFactory().getDBOr(arity);
        }

        private int rankTerms(ImmutableTerm term, boolean conjunction) {
            if (!(term instanceof ImmutableFunctionalTerm)) {
                return 3;
            }
            ImmutableFunctionalTerm f = (ImmutableFunctionalTerm)term;
            if (InMergingTransformer.isBooleanOperation((ImmutableTerm)f) && f.getFunctionSymbol() instanceof DBAndFunctionSymbol != conjunction) {
                return 2;
            }
            if (InMergingTransformer.isBooleanOperation((ImmutableTerm)f) && f.getFunctionSymbol() instanceof DBAndFunctionSymbol == conjunction) {
                return 1;
            }
            if (f.getFunctionSymbol() instanceof DBInFunctionSymbol) {
                return 0;
            }
            return 4;
        }

        private ImmutableTerm mergeAll(ImmutableList<ImmutableTerm> terms, boolean conjunction) {
            ImmutableList sorted = (ImmutableList)terms.stream().sorted((t1, t2) -> this.rankTerms((ImmutableTerm)t1, conjunction) - this.rankTerms((ImmutableTerm)t2, conjunction)).collect(ImmutableCollectors.toList());
            return sorted.stream().skip(1L).reduce((ImmutableTerm)sorted.get(0), (current, next) -> {
                if (InMergingTransformer.isBooleanOperation(current) && ((ImmutableFunctionalTerm)current).getArity() > 8) {
                    return conjunction ? this.termFactory.getConjunction((ImmutableExpression)next, new ImmutableExpression[]{(ImmutableExpression)current}) : this.termFactory.getDisjunction((ImmutableExpression)next, new ImmutableExpression[]{(ImmutableExpression)current});
                }
                return this.merge((ImmutableTerm)current, (ImmutableTerm)next, conjunction);
            }, (m1, m2) -> {
                throw new UnsupportedOperationException("This should never happen!");
            });
        }

        private ImmutableTerm merge(ImmutableTerm left, ImmutableTerm right, boolean conjunction) {
            if (!(left instanceof ImmutableFunctionalTerm) || !(right instanceof ImmutableFunctionalTerm)) {
                return this.conjunctionDisjunctionOf((ImmutableList<? extends ImmutableTerm>)ImmutableList.of((Object)left, (Object)right), conjunction);
            }
            ImmutableFunctionalTerm fLeft = DisjunctionOfEqualitiesMergingSimplifierImpl.convertSingleEqualities(left, this.termFactory).orElse((ImmutableFunctionalTerm)left);
            ImmutableFunctionalTerm fRight = DisjunctionOfEqualitiesMergingSimplifierImpl.convertSingleEqualities(right, this.termFactory).orElse((ImmutableFunctionalTerm)right);
            if (fRight.getFunctionSymbol() instanceof DBInFunctionSymbol) {
                return this.mergeInto((ImmutableTerm)fLeft, fRight, conjunction);
            }
            if (fLeft.getFunctionSymbol() instanceof DBInFunctionSymbol) {
                return this.mergeInto((ImmutableTerm)fRight, fLeft, conjunction);
            }
            if (!InMergingTransformer.isBooleanOperation((ImmutableTerm)fLeft) || !InMergingTransformer.isBooleanOperation((ImmutableTerm)fRight)) {
                return this.conjunctionDisjunctionOf((ImmutableList<? extends ImmutableTerm>)ImmutableList.of((Object)left, (Object)right), conjunction);
            }
            if (fLeft.getArity() > 8 || fRight.getArity() > 8) {
                return this.conjunctionDisjunctionOf((ImmutableList<? extends ImmutableTerm>)ImmutableList.of((Object)left, (Object)right), conjunction);
            }
            if (!Sets.intersection(this.findAllSearchTerms(fLeft), this.findAllSearchTerms(fRight)).isEmpty()) {
                return this.crossMerge(fLeft, fRight, conjunction);
            }
            return this.conjunctionDisjunctionOf((ImmutableList<? extends ImmutableTerm>)ImmutableList.of((Object)left, (Object)right), conjunction);
        }

        private ImmutableTerm crossMerge(ImmutableFunctionalTerm left, ImmutableFunctionalTerm right, boolean conjunction) {
            boolean rightConjunction = right.getFunctionSymbol() instanceof DBAndFunctionSymbol;
            ImmutableList terms = (ImmutableList)right.getTerms().stream().map(t -> this.merge((ImmutableTerm)left, (ImmutableTerm)t, conjunction)).flatMap(t -> InMergingTransformer.isBooleanOperation(t) && ((ImmutableFunctionalTerm)t).getFunctionSymbol() instanceof DBAndFunctionSymbol == rightConjunction ? ((ImmutableFunctionalTerm)t).getTerms().stream() : Stream.of(t)).collect(ImmutableCollectors.toList());
            return this.conjunctionDisjunctionOf((ImmutableList<? extends ImmutableTerm>)terms, rightConjunction);
        }

        private ImmutableSet<ImmutableTerm> findAllSearchTerms(ImmutableFunctionalTerm term) {
            if (term.getFunctionSymbol() instanceof DBInFunctionSymbol) {
                return ImmutableSet.of((Object)term.getTerm(0));
            }
            if (InMergingTransformer.isBooleanOperation((ImmutableTerm)term)) {
                return (ImmutableSet)term.getTerms().stream().filter(t -> t instanceof ImmutableFunctionalTerm).flatMap(t -> this.findAllSearchTerms((ImmutableFunctionalTerm)t).stream()).collect(ImmutableCollectors.toSet());
            }
            return ImmutableSet.of();
        }

        private ImmutableTerm mergeInto(ImmutableTerm target, ImmutableFunctionalTerm in, boolean conjunction) {
            Optional<ImmutableFunctionalTerm> targetFunction = Optional.of(target).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t);
            if (targetFunction.filter(t -> InMergingTransformer.isBooleanOperation((ImmutableTerm)t) && t.getArity() <= 8 || t.getFunctionSymbol() instanceof DBInFunctionSymbol).isEmpty() || !this.findAllSearchTerms(targetFunction.get()).contains((Object)in.getTerm(0))) {
                return this.conjunctionDisjunctionOf((ImmutableList<? extends ImmutableTerm>)ImmutableList.of((Object)target, (Object)in), conjunction);
            }
            ImmutableFunctionalTerm f = targetFunction.get();
            if (f.getFunctionSymbol() instanceof DBInFunctionSymbol) {
                if (this.canMergeWith((ImmutableList<? extends ImmutableTerm>)f.getTerms(), (ImmutableList<? extends ImmutableTerm>)in.getTerms())) {
                    return this.mergeWith((ImmutableList<? extends ImmutableTerm>)f.getTerms(), (ImmutableList<? extends ImmutableTerm>)in.getTerms(), conjunction);
                }
                return this.conjunctionDisjunctionOf((ImmutableList<? extends ImmutableTerm>)ImmutableList.of((Object)f, (Object)in), conjunction);
            }
            if (conjunction && this.isImpliedBy(in, f) || !conjunction && this.isImpliedBy(f, in)) {
                return in;
            }
            boolean targetConjunction = f.getFunctionSymbol() instanceof DBAndFunctionSymbol;
            return targetConjunction == conjunction ? this.mergeSameOperation(f, in, conjunction) : this.mergeOppositeOperation(f, in, conjunction);
        }

        private boolean canMergeInto(ImmutableTerm target, ImmutableFunctionalTerm in) {
            if (!(target instanceof ImmutableFunctionalTerm)) {
                return false;
            }
            ImmutableFunctionalTerm f = (ImmutableFunctionalTerm)target;
            if (f.getFunctionSymbol() instanceof DBInFunctionSymbol) {
                return this.canMergeWith((ImmutableList<? extends ImmutableTerm>)f.getTerms(), (ImmutableList<? extends ImmutableTerm>)in.getTerms());
            }
            if (InMergingTransformer.isBooleanOperation((ImmutableTerm)f)) {
                return f.getTerms().stream().anyMatch(child -> this.canMergeInto((ImmutableTerm)child, in));
            }
            return false;
        }

        private ImmutableTerm mergeOppositeOperation(ImmutableFunctionalTerm operation, ImmutableFunctionalTerm in, boolean conjunction) {
            ImmutableMap canCancel = (ImmutableMap)operation.getTerms().stream().collect(ImmutableCollectors.partitioningBy(child -> this.canMergeInto((ImmutableTerm)child, in)));
            ImmutableList finalTerms = (ImmutableList)Streams.concat((Stream[])new Stream[]{((ImmutableList)canCancel.get((Object)false)).isEmpty() ? Stream.of(new ImmutableTerm[0]) : Stream.of(this.termFactory.getImmutableExpression(this.operatorSymbol(2, conjunction), new ImmutableTerm[]{this.conjunctionDisjunctionOf((ImmutableList<? extends ImmutableTerm>)((ImmutableList)canCancel.get((Object)false)), !conjunction), in})), ((ImmutableList)canCancel.get((Object)true)).stream().map(term -> this.mergeInto((ImmutableTerm)term, in, conjunction))}).collect(ImmutableCollectors.toList());
            return this.conjunctionDisjunctionOf((ImmutableList<? extends ImmutableTerm>)finalTerms, !conjunction);
        }

        private boolean isImpliedByTerm(ImmutableTerm determinant, ImmutableTerm dependent) {
            if (!(determinant instanceof ImmutableFunctionalTerm) || !(dependent instanceof ImmutableFunctionalTerm)) {
                return false;
            }
            return this.isImpliedBy((ImmutableFunctionalTerm)determinant, (ImmutableFunctionalTerm)dependent);
        }

        private boolean isImpliedBy(ImmutableFunctionalTerm determinant, ImmutableFunctionalTerm dependent) {
            if (determinant.getFunctionSymbol() instanceof DBInFunctionSymbol && dependent.getFunctionSymbol() instanceof DBInFunctionSymbol) {
                return determinant.getTerm(0).equals(dependent.getTerm(0)) && Sets.difference((Set)ImmutableSet.copyOf((Collection)determinant.getTerms()), (Set)ImmutableSet.copyOf((Collection)dependent.getTerms())).isEmpty();
            }
            if (determinant.getFunctionSymbol() instanceof DBInFunctionSymbol && InMergingTransformer.isBooleanOperation((ImmutableTerm)dependent)) {
                if (dependent.getFunctionSymbol() instanceof DBAndFunctionSymbol) {
                    return dependent.getTerms().stream().allMatch(term -> this.isImpliedByTerm((ImmutableTerm)determinant, (ImmutableTerm)term));
                }
                return dependent.getTerms().stream().anyMatch(term -> this.isImpliedByTerm((ImmutableTerm)determinant, (ImmutableTerm)term));
            }
            if (dependent.getFunctionSymbol() instanceof DBInFunctionSymbol && InMergingTransformer.isBooleanOperation((ImmutableTerm)determinant)) {
                if (determinant.getFunctionSymbol() instanceof DBAndFunctionSymbol) {
                    return determinant.getTerms().stream().anyMatch(term -> this.isImpliedByTerm((ImmutableTerm)term, (ImmutableTerm)dependent));
                }
                return determinant.getTerms().stream().allMatch(term -> this.isImpliedByTerm((ImmutableTerm)term, (ImmutableTerm)dependent));
            }
            if (InMergingTransformer.isBooleanOperation((ImmutableTerm)determinant) && InMergingTransformer.isBooleanOperation((ImmutableTerm)dependent)) {
                throw new UnsupportedOperationException("This condition is not implemented because it should not come up.");
            }
            return false;
        }

        private ImmutableTerm mergeSameOperation(ImmutableFunctionalTerm operation, ImmutableFunctionalTerm in, boolean conjunction) {
            Optional<ImmutableTerm> compatibleChild = operation.getTerms().stream().filter(child -> this.canMergeInto((ImmutableTerm)child, in)).findFirst();
            if (compatibleChild.isPresent()) {
                return this.termFactory.getImmutableExpression(this.operatorSymbol(operation.getArity(), conjunction), (ImmutableList)operation.getTerms().stream().map(child -> child == compatibleChild.get() ? this.mergeInto((ImmutableTerm)child, in, conjunction) : child).collect(ImmutableCollectors.toList()));
            }
            return this.termFactory.getImmutableExpression(this.operatorSymbol(operation.getArity() + 1, conjunction), (ImmutableList)Streams.concat((Stream[])new Stream[]{operation.getTerms().stream(), Stream.of(in)}).collect(ImmutableCollectors.toList()));
        }

        protected ImmutableFunctionalTerm replaceFunctionSymbol(FunctionSymbol functionSymbol, ImmutableList<ImmutableTerm> newTerms, IQTree tree) {
            if (newTerms.size() > 8) {
                return this.termFactory.getImmutableExpression((BooleanFunctionSymbol)functionSymbol, newTerms);
            }
            return (ImmutableFunctionalTerm)this.mergeAll(newTerms, functionSymbol instanceof DBAndFunctionSymbol);
        }

        private ImmutableTerm conjunctionDisjunctionOf(ImmutableList<? extends ImmutableTerm> terms, boolean conjunction) {
            if (terms.size() == 1) {
                return (ImmutableTerm)terms.get(0);
            }
            return this.termFactory.getImmutableExpression(this.operatorSymbol(terms.size(), conjunction), terms);
        }

        private boolean canMergeWith(ImmutableList<? extends ImmutableTerm> ownTerms, ImmutableList<? extends ImmutableTerm> otherTerms) {
            return ((ImmutableTerm)ownTerms.get(0)).equals(otherTerms.get(0)) && ownTerms.stream().skip(1L).allMatch(t -> t instanceof Constant) && otherTerms.stream().skip(1L).allMatch(t -> t instanceof Constant);
        }

        private ImmutableExpression mergeWith(ImmutableList<? extends ImmutableTerm> ownTerms, ImmutableList<? extends ImmutableTerm> otherTerms, boolean conjunction) {
            ImmutableSet ownChildren = (ImmutableSet)ownTerms.stream().skip(1L).collect(ImmutableCollectors.toSet());
            ImmutableSet otherChildren = (ImmutableSet)otherTerms.stream().skip(1L).collect(ImmutableCollectors.toSet());
            ImmutableList mergedChildren = (ImmutableList)Streams.concat((Stream[])new Stream[]{Stream.of((ImmutableTerm)ownTerms.get(0)), conjunction ? Sets.intersection((Set)ownChildren, (Set)otherChildren).stream() : Sets.union((Set)ownChildren, (Set)otherChildren).stream()}).collect(ImmutableCollectors.toList());
            return this.termFactory.getImmutableExpression((BooleanFunctionSymbol)this.termFactory.getDBFunctionSymbolFactory().getStrictDBIn(mergedChildren.size()), mergedChildren);
        }
    }

    protected static class InCreatingTransformer
    extends AbstractExpressionTransformer {
        protected InCreatingTransformer(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
            super(iqFactory, typeExtractor, termFactory);
        }

        protected boolean isFunctionSymbolToReplace(FunctionSymbol functionSymbol) {
            return functionSymbol instanceof DBOrFunctionSymbol;
        }

        protected ImmutableFunctionalTerm replaceFunctionSymbol(FunctionSymbol functionSymbol, ImmutableList<ImmutableTerm> newTerms, IQTree tree) {
            ImmutableMap equalities = (ImmutableMap)newTerms.stream().collect(ImmutableCollectors.partitioningBy(x$0 -> DisjunctionOfEqualitiesMergingSimplifierImpl.isConvertableEquality(x$0)));
            Map<ImmutableTerm, List<ImmutableFunctionalTerm>> converted = ((ImmutableList)equalities.get((Object)true)).stream().map(t -> DisjunctionOfEqualitiesMergingSimplifierImpl.convertSingleEqualities(t, this.termFactory).orElseThrow()).collect(Collectors.groupingBy(t -> t.getTerm(0)));
            return (ImmutableFunctionalTerm)this.termFactory.getDisjunction(Streams.concat((Stream[])new Stream[]{((ImmutableList)equalities.get((Object)false)).stream().map(t -> (ImmutableExpression)t), converted.entrySet().stream().map(entry -> this.termFactory.getImmutableExpression((BooleanFunctionSymbol)this.termFactory.getDBFunctionSymbolFactory().getStrictDBIn(1 + ((List)entry.getValue()).size()), (ImmutableList)Streams.concat((Stream[])new Stream[]{Stream.of((ImmutableTerm)entry.getKey()), ((List)entry.getValue()).stream().flatMap(t -> t.getTerms().stream().skip(1L))}).collect(ImmutableCollectors.toList())))})).orElseThrow();
        }
    }
}

