/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.FlattenLifter;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BasicFlattenLifter
implements FlattenLifter {
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private BasicFlattenLifter(IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
    }

    @Override
    public IQ optimize(IQ query) {
        TreeTransformer treeTransformer = new TreeTransformer(this.iqFactory);
        return this.iqFactory.createIQ(query.getProjectionAtom(), query.getTree().acceptTransformer((IQTreeVisitingTransformer)treeTransformer));
    }

    private static class FlattenLifterException
    extends OntopInternalBugException {
        FlattenLifterException(String message) {
            super(message);
        }
    }

    private static class SplitFlattenSequence {
        private final List<FlattenNode> liftableFlatten = new LinkedList<FlattenNode>();
        private final List<FlattenNode> nonLiftableFlatten = new LinkedList<FlattenNode>();

        private void appendLiftable(FlattenNode flattenNode) {
            this.liftableFlatten.add(flattenNode);
        }

        private void appendNonLiftable(FlattenNode flattenNode) {
            this.nonLiftableFlatten.add(flattenNode);
        }
    }

    private static class TreeTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        TreeTransformer(IntermediateQueryFactory iqFactory) {
            super(iqFactory);
        }

        public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
            ImmutableList<FlattenNode> flattenNodes = this.getRootFlattenNodes(child = child.acceptTransformer((IQTreeVisitingTransformer)this));
            if (flattenNodes.isEmpty()) {
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, child);
            }
            child = this.discardRootFlattenNodes(child, (UnmodifiableIterator<FlattenNode>)flattenNodes.iterator());
            return this.liftAboveConjunct(rootNode.getFilterCondition().flattenAND().collect(Collectors.toCollection(LinkedList::new)), (List<FlattenNode>)flattenNodes, child);
        }

        public IQTree transformConstruction(IQTree tree, ConstructionNode cn, IQTree child) {
            child = child.acceptTransformer((IQTreeVisitingTransformer)this);
            if (tree.getRootNode().equals(cn)) {
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)cn, child);
            }
            ImmutableList<FlattenNode> flattenNodes = this.getRootFlattenNodes(child);
            child = this.discardRootFlattenNodes(child, (UnmodifiableIterator<FlattenNode>)flattenNodes.iterator());
            SplitFlattenSequence splitFlattenSequence = this.splitFlattenSequence((List<FlattenNode>)flattenNodes, (ImmutableSet<Variable>)ImmutableSet.of());
            return this.buildUnaryTree(splitFlattenSequence.liftableFlatten.iterator(), (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.updateConstructionNode(cn, splitFlattenSequence.liftableFlatten.iterator()), this.buildUnaryTree(splitFlattenSequence.nonLiftableFlatten.iterator(), child)));
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode join, ImmutableList<IQTree> children) {
            children = (ImmutableList)children.stream().map(c -> c.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList());
            ImmutableList flattenLists = (ImmutableList)children.stream().map(this::getRootFlattenNodes).collect(ImmutableCollectors.toList());
            ImmutableSet<Variable> blockingVars = this.getImplicitJoinCondition((ImmutableList<IQTree>)children);
            UnmodifiableIterator it = flattenLists.iterator();
            children = (ImmutableList)children.stream().map(arg_0 -> this.lambda$transformInnerJoin$1((Iterator)it, arg_0)).collect(ImmutableCollectors.toList());
            ImmutableList flattenSequences = (ImmutableList)flattenLists.stream().map(l -> this.splitFlattenSequence((List<FlattenNode>)l, blockingVars)).collect(ImmutableCollectors.toList());
            ImmutableList liftedFlattenNodes = (ImmutableList)flattenSequences.stream().flatMap(fs -> fs.liftableFlatten.stream()).collect(ImmutableCollectors.toList());
            UnmodifiableIterator its = flattenSequences.iterator();
            ImmutableList updatedChildren = (ImmutableList)children.stream().map(arg_0 -> this.lambda$transformInnerJoin$4((Iterator)its, arg_0)).collect(ImmutableCollectors.toList());
            return this.buildUnaryTree((Iterator<FlattenNode>)liftedFlattenNodes.iterator(), (IQTree)this.iqFactory.createNaryIQTree((NaryOperatorNode)join, updatedChildren));
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            ImmutableList children = ImmutableList.of((Object)leftChild, (Object)rightChild);
            children = (ImmutableList)children.stream().map(c -> c.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList());
            ImmutableList flattenLists = (ImmutableList)children.stream().map(this::getRootFlattenNodes).collect(ImmutableCollectors.toList());
            ImmutableSet blockingVars = Sets.union(this.getImplicitJoinCondition((ImmutableList<IQTree>)children), (Set)rootNode.getLocallyRequiredVariables()).immutableCopy();
            UnmodifiableIterator it = flattenLists.iterator();
            children = (ImmutableList)children.stream().map(arg_0 -> this.lambda$transformLeftJoin$6((Iterator)it, arg_0)).collect(ImmutableCollectors.toList());
            ImmutableList flattenSequences = (ImmutableList)flattenLists.stream().map(l -> this.splitFlattenSequence((List<FlattenNode>)l, (ImmutableSet<Variable>)blockingVars)).collect(ImmutableCollectors.toList());
            ImmutableList liftedFlattenNodes = (ImmutableList)flattenSequences.stream().flatMap(fs -> fs.liftableFlatten.stream()).collect(ImmutableCollectors.toList());
            UnmodifiableIterator its = flattenSequences.iterator();
            ImmutableList updatedChildren = (ImmutableList)children.stream().map(arg_0 -> this.lambda$transformLeftJoin$9((Iterator)its, arg_0)).collect(ImmutableCollectors.toList());
            return this.buildUnaryTree((Iterator<FlattenNode>)liftedFlattenNodes.iterator(), (IQTree)this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, (IQTree)updatedChildren.get(0), (IQTree)updatedChildren.get(1)));
        }

        private ConstructionNode updateConstructionNode(ConstructionNode cn, Iterator<FlattenNode> it) {
            if (it.hasNext()) {
                FlattenNode fn = it.next();
                ImmutableSet projectedVars = Sets.union((Set)Sets.difference((Set)cn.getVariables(), (Set)fn.getLocallyDefinedVariables()), (Set)ImmutableSet.of((Object)fn.getFlattenedVariable())).immutableCopy();
                ConstructionNode updatedCn = this.iqFactory.createConstructionNode(projectedVars, cn.getSubstitution());
                return this.updateConstructionNode(updatedCn, it);
            }
            return cn;
        }

        private SplitFlattenSequence splitFlattenSequence(List<FlattenNode> flattenNodes, ImmutableSet<Variable> blockingVars) {
            return this.split(new SplitFlattenSequence(), flattenNodes.iterator(), blockingVars);
        }

        private SplitFlattenSequence split(SplitFlattenSequence splitFlattenSequence, Iterator<FlattenNode> it, ImmutableSet<Variable> blockingVars) {
            if (it.hasNext()) {
                FlattenNode flattenNode = it.next();
                if (flattenNode.getLocallyDefinedVariables().stream().anyMatch(arg_0 -> blockingVars.contains(arg_0))) {
                    splitFlattenSequence.appendNonLiftable(flattenNode);
                    blockingVars = Sets.union((Set)ImmutableSet.of((Object)flattenNode.getFlattenedVariable()), blockingVars).immutableCopy();
                } else {
                    splitFlattenSequence.appendLiftable(flattenNode);
                }
                return this.split(splitFlattenSequence, it, blockingVars);
            }
            return splitFlattenSequence;
        }

        private IQTree buildUnaryTree(Iterator<FlattenNode> it, IQTree subtree) {
            if (it.hasNext()) {
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)it.next(), this.buildUnaryTree(it, subtree));
            }
            return subtree;
        }

        private ImmutableSet<Variable> getImplicitJoinCondition(ImmutableList<IQTree> children) {
            return (ImmutableSet)((ImmutableMultiset)children.stream().flatMap(n -> n.getVariables().stream()).collect(ImmutableCollectors.toMultiset())).entrySet().stream().filter(e -> e.getCount() > 1).map(Multiset.Entry::getElement).collect(ImmutableCollectors.toSet());
        }

        private IQTree discardRootFlattenNodes(IQTree tree, UnmodifiableIterator<FlattenNode> it) {
            if (it.hasNext()) {
                FlattenNode node = (FlattenNode)it.next();
                if (tree.getRootNode().equals(node)) {
                    return this.discardRootFlattenNodes(((UnaryIQTree)tree).getChild(), it);
                }
                throw new FlattenLifterException("Node " + node + " is expected top be the root of " + tree);
            }
            return tree;
        }

        private ImmutableList<FlattenNode> getRootFlattenNodes(IQTree tree) {
            return this.getRootFlattenNodesRec(tree, (ImmutableList.Builder<FlattenNode>)ImmutableList.builder()).build();
        }

        private ImmutableList.Builder<FlattenNode> getRootFlattenNodesRec(IQTree tree, ImmutableList.Builder<FlattenNode> builder) {
            QueryNode n = tree.getRootNode();
            if (n instanceof FlattenNode) {
                builder.add((Object)((FlattenNode)n));
                return this.getRootFlattenNodesRec(((UnaryIQTree)tree).getChild(), builder);
            }
            return builder;
        }

        private IQTree liftAboveConjunct(LinkedList<ImmutableExpression> conjuncts, List<FlattenNode> flattenNodes, IQTree child) {
            if (conjuncts.isEmpty()) {
                return this.buildUnaryTree(flattenNodes.iterator(), child);
            }
            ImmutableExpression conjunct = conjuncts.removeFirst();
            SplitFlattenSequence split = this.splitFlattenSequence(flattenNodes, (ImmutableSet<Variable>)conjunct.getVariables());
            child = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(conjunct), this.buildUnaryTree(split.nonLiftableFlatten.iterator(), child));
            return this.liftAboveConjunct(conjuncts, split.liftableFlatten, child);
        }

        private /* synthetic */ IQTree lambda$transformLeftJoin$9(Iterator its, IQTree t) {
            return this.buildUnaryTree(((SplitFlattenSequence)its.next()).nonLiftableFlatten.iterator(), t);
        }

        private /* synthetic */ IQTree lambda$transformLeftJoin$6(Iterator it, IQTree t) {
            return this.discardRootFlattenNodes(t, (UnmodifiableIterator<FlattenNode>)((ImmutableList)it.next()).iterator());
        }

        private /* synthetic */ IQTree lambda$transformInnerJoin$4(Iterator its, IQTree t) {
            return this.buildUnaryTree(((SplitFlattenSequence)its.next()).nonLiftableFlatten.iterator(), t);
        }

        private /* synthetic */ IQTree lambda$transformInnerJoin$1(Iterator it, IQTree t) {
            return this.discardRootFlattenNodes(t, (UnmodifiableIterator<FlattenNode>)((ImmutableList)it.next()).iterator());
        }
    }
}

