/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.optimizer.InnerJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractSelfJoinSimplifier;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionOperations;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ArgumentTransferInnerJoinFDIQOptimizer
implements InnerJoinIQOptimizer {
    private final IntermediateQueryFactory iqFactory;
    private final CoreSingletons coreSingletons;
    private final SelfJoinFDSimplifier simplifier;

    @Inject
    protected ArgumentTransferInnerJoinFDIQOptimizer(CoreSingletons coreSingletons, IQTreeTools iqTreeTools) {
        this.simplifier = new SelfJoinFDSimplifier(coreSingletons, iqTreeTools);
        this.iqFactory = coreSingletons.getIQFactory();
        this.coreSingletons = coreSingletons;
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree;
        ArgumentTransferJoinTransformer transformer = new ArgumentTransferJoinTransformer(this.simplifier, this.coreSingletons, query.getVariableGenerator());
        IQTree newTree = transformer.transform(initialTree = query.getTree());
        return newTree == initialTree ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    protected static class SelfJoinFDSimplifier
    extends AbstractSelfJoinSimplifier<FunctionalDependency> {
        protected SelfJoinFDSimplifier(CoreSingletons coreSingletons, IQTreeTools iqTreeTools) {
            super(coreSingletons, iqTreeTools);
        }

        @Override
        protected boolean canEliminateNodes() {
            return false;
        }

        @Override
        protected boolean hasConstraint(ExtensionalDataNode node) {
            return !node.getRelationDefinition().getOtherFunctionalDependencies().isEmpty();
        }

        @Override
        protected Stream<FunctionalDependency> extractConstraints(RelationDefinition relationDefinition) {
            return relationDefinition.getOtherFunctionalDependencies().stream();
        }

        @Override
        protected Optional<AbstractSelfJoinSimplifier.DeterminantGroupEvaluation> evaluateDeterminantGroup(ImmutableList<VariableOrGroundTerm> determinants, Collection<ExtensionalDataNode> dataNodes, FunctionalDependency constraint) {
            if (dataNodes.size() < 2) {
                throw new IllegalArgumentException("At least two nodes");
            }
            AbstractSelfJoinSimplifier.NormalizationBeforeUnification normalization = this.normalizeDataNodes(dataNodes, constraint);
            ExtensionalDataNode targetDataNode = this.selectTargetDataNode(normalization.dataNodes, constraint);
            ImmutableSet dependentIndexes = (ImmutableSet)constraint.getDependents().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
            ImmutableSet<ImmutableExpression> expressions = this.extractExpressions(dataNodes, normalization.equalities, (ImmutableSet<Integer>)dependentIndexes);
            return ((Optional)normalization.dataNodes.stream().map(n -> ExtensionalDataNode.restrictTo((ImmutableMap)n.getArgumentMap(), arg_0 -> ((ImmutableSet)dependentIndexes).contains(arg_0))).collect(this.substitutionFactory.onVariableOrGroundTerms().toArgumentMapUnifier())).map(u -> this.convertIntoDeterminantGroupEvaluation((SubstitutionOperations.ArgumentMapUnifier<VariableOrGroundTerm>)u, targetDataNode, (ImmutableList<ExtensionalDataNode>)ImmutableList.copyOf(normalization.dataNodes), expressions, (ImmutableSet<Integer>)dependentIndexes));
        }

        protected ExtensionalDataNode selectTargetDataNode(Collection<ExtensionalDataNode> dataNodes, FunctionalDependency constraint) {
            ImmutableSet dependentAttributes = constraint.getDependents();
            ImmutableSet determinantAttributes = constraint.getDeterminants();
            RelationDefinition relationDefinition = dataNodes.iterator().next().getRelationDefinition();
            ImmutableSet externalArgumentIndexes = (ImmutableSet)relationDefinition.getAttributes().stream().filter(a -> !dependentAttributes.contains(a)).filter(a -> !determinantAttributes.contains(a)).map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
            ImmutableMap nodeExternalArgumentMap = (ImmutableMap)dataNodes.stream().distinct().collect(ImmutableCollectors.toMap(n -> n, n -> ExtensionalDataNode.restrictTo((ImmutableMap)n.getArgumentMap(), arg_0 -> ((ImmutableSet)externalArgumentIndexes).contains(arg_0))));
            return dataNodes.stream().max(Comparator.comparingInt(n -> ((ImmutableMap)nodeExternalArgumentMap.get(n)).values().size())).orElseThrow(() -> new MinorOntopInternalBugException("Non empty collection expected"));
        }

        private AbstractSelfJoinSimplifier.DeterminantGroupEvaluation convertIntoDeterminantGroupEvaluation(SubstitutionOperations.ArgumentMapUnifier<VariableOrGroundTerm> argumentMapUnification, ExtensionalDataNode targetDataNode, ImmutableList<ExtensionalDataNode> dataNodes, ImmutableSet<ImmutableExpression> expressions, ImmutableSet<Integer> dependentIndexes) {
            int targetIndex = dataNodes.indexOf((Object)targetDataNode);
            ImmutableList newNodes = (ImmutableList)IntStream.range(0, dataNodes.size()).mapToObj(i -> i == targetIndex ? this.iqFactory.createExtensionalDataNode(targetDataNode.getRelationDefinition(), ExtensionalDataNode.union((ImmutableMap)argumentMapUnification.getArgumentMap(), (ImmutableMap)targetDataNode.getArgumentMap())) : this.iqFactory.createExtensionalDataNode(((ExtensionalDataNode)dataNodes.get(i)).getRelationDefinition(), ExtensionalDataNode.restrictTo((ImmutableMap)((ExtensionalDataNode)dataNodes.get(i)).getArgumentMap(), idx -> !dependentIndexes.contains(idx)))).collect(ImmutableCollectors.toList());
            return new AbstractSelfJoinSimplifier.DeterminantGroupEvaluation(expressions, (ImmutableList<ExtensionalDataNode>)newNodes, (Substitution<VariableOrGroundTerm>)argumentMapUnification.getSubstitution());
        }

        private ImmutableSet<ImmutableExpression> extractExpressions(Collection<ExtensionalDataNode> dataNodes, ImmutableSet<ImmutableExpression> equalities, ImmutableSet<Integer> dependentIndexes) {
            ImmutableMultiset dependentVariableOccurrences = (ImmutableMultiset)dataNodes.stream().flatMap(n -> n.getArgumentMap().entrySet().stream()).filter(e -> !dependentIndexes.contains(e.getKey())).map(Map.Entry::getValue).filter(d -> d instanceof Variable).map(d -> (Variable)d).collect(ImmutableCollectors.toMultiset());
            return (ImmutableSet)Stream.concat(dependentVariableOccurrences.entrySet().stream().filter(e -> e.getCount() > 1).map(Multiset.Entry::getElement).map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)), equalities.stream()).collect(ImmutableCollectors.toSet());
        }
    }

    protected static class ArgumentTransferJoinTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final SelfJoinFDSimplifier simplifier;
        private final VariableGenerator variableGenerator;

        protected ArgumentTransferJoinTransformer(SelfJoinFDSimplifier simplifier, CoreSingletons coreSingletons, VariableGenerator variableGenerator) {
            super(coreSingletons);
            this.simplifier = simplifier;
            this.variableGenerator = variableGenerator;
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            return this.simplifier.transformInnerJoin(rootNode, children, (ImmutableSet<Variable>)tree.getVariables(), this.variableGenerator).orElse(tree);
        }
    }
}

