/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.stats.swagger;

import com.google.common.io.Resources;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.graphdb.Config;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/rest/api/rdf4j"})
public class Rdf4JSwagger2Controller {
    @GetMapping(produces={"text/x-yaml"})
    public ResponseEntity<String> autoDiscoverBasePath(HttpServletRequest servletRequest) throws GraphDBWorkbenchException {
        URL resource = Optional.of(Resources.getResource((String)"/rdf4j.yaml")).orElseThrow(() -> new IllegalStateException("Cannot find RDF4J Swagger REST API description"));
        try {
            String yamlApiDescription = Resources.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
            URI externalUrl = Config.lookupVirtualHost((String)servletRequest.getHeader("Referer"));
            String forwardedPrefix = servletRequest.getHeader("x-forwarded-prefix");
            String contextPath = externalUrl != null && StringUtils.isNotEmpty((CharSequence)forwardedPrefix) ? forwardedPrefix : servletRequest.getContextPath();
            yamlApiDescription = yamlApiDescription.replace("${basePath}", contextPath.isEmpty() ? "/" : contextPath);
            return new ResponseEntity((Object)yamlApiDescription, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            throw new GraphDBWorkbenchException("Cannot read RDF4J Swagger REST API description ", (Throwable)e);
        }
    }
}

