/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.google;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.ontotext.graphdb.Config;
import com.ontotext.license.LicenseRegistry;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleUtils {
    private static final Logger logger = LoggerFactory.getLogger(GoogleUtils.class);
    private static final int GCLOUD_PART_MIN_SIZE = 0x4000000;
    public static final String GRAPHDB_GCLOUD_MIN_PART_SIZE = "graphdb.gs.min.part.size";
    public static final int GCLOUD_ESTIMATED_PART_COUNT = 9500;
    public static final long GCLOUD_FILE_LIMIT = 5000000000000L;
    public static final String GRAPHDB_GOOGLE_STORAGE_CUSTOM_ENDPOINT = "graphdb.gs.custom.endpoint";
    public static final String HTTPCLIENT_WRITE_TIMEOUT = "graphdb.gs.backup.client.write.timeout";
    public static final int DEFAULT_WRITE_TIMEOUT = 3600;
    public static final String GRAPHDB_GS_BACKUP_MAX_CONCURRENT_UPLOADS = "graphdb.gs.backup.max.concurrent.uploads";
    public static final int DEFAULT_MAX_CONCURRENT_UPLOADS = 6;
    private static final int CONFIGURED_CONCURRENT_UPLOADS;
    private static final String GRAPHDB_GOOGLE_STORAGE_CREDENTIALS_SCOPE = "graphdb.gs.credentials.scope";
    private static final String DEFAULT_CREDENTIALS_SCOPE = "https://www.googleapis.com/auth/devstorage.read_write";

    public static int getMinimumPartSize() {
        return Config.getPropertyAsInt((String)GRAPHDB_GCLOUD_MIN_PART_SIZE, (int)0x4000000);
    }

    public static int getClientWriteTimeout() {
        return Config.getPropertyAsInt((String)HTTPCLIENT_WRITE_TIMEOUT, (int)3600);
    }

    public static int getAllowedConcurrentUploads() {
        return LicenseRegistry.getInstance().getLicensedCores(CONFIGURED_CONCURRENT_UPLOADS);
    }

    static String getStorageDomain() {
        String customEndpoint = Config.getProperty((String)GRAPHDB_GOOGLE_STORAGE_CUSTOM_ENDPOINT);
        if (StringUtils.isBlank((CharSequence)customEndpoint)) {
            return "https://storage.googleapis.com/";
        }
        logger.debug("Custom google cloud endpoint in use: {}", (Object)customEndpoint);
        return customEndpoint;
    }

    public static String getCredentialsScope() {
        return Config.getProperty((String)GRAPHDB_GOOGLE_STORAGE_CREDENTIALS_SCOPE, (String)DEFAULT_CREDENTIALS_SCOPE);
    }

    public static long getGoogleCloudFileSize(String url, HttpRequestFactory requestFactory) throws IOException {
        HttpRequest request = requestFactory.buildHeadRequest(new GenericUrl(url));
        HttpResponse response = request.execute();
        if (!response.isSuccessStatusCode()) {
            throw new IOException(response.getStatusMessage());
        }
        long fileSize = Long.parseLong(response.getHeaders().get((Object)"content-length").toString().replace("[", "").replace("]", ""));
        if (fileSize > 0L) {
            return fileSize;
        }
        throw new IOException("Invalid backup file size: " + fileSize);
    }

    static {
        int uploads = Config.getPropertyAsInt((String)GRAPHDB_GS_BACKUP_MAX_CONCURRENT_UPLOADS, (int)6);
        if (uploads > 16 || uploads < 1) {
            logger.warn("Invalid upload count for Google Cloud upload \"{}\", switching to default value {}", (Object)uploads, (Object)6);
            uploads = 6;
        }
        logger.debug("Google CLoud will use maximum {} concurrent uploads", (Object)uploads);
        CONFIGURED_CONCURRENT_UPLOADS = uploads;
    }
}

