/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.google;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.ontotext.graphdb.cloud.google.GoogleUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class GCPartUpload
implements Runnable {
    private final int partNumber;
    private final Map<Integer, String> partsMap;
    private final String bucket;
    private final String fileKey;
    private final String uploadId;
    private final byte[] uploadChunk;
    private final AtomicReference<IOException> exception;
    private final HttpRequestFactory requestFactory;

    public GCPartUpload(HttpRequestFactory requestFactory, int partNumber, Map<Integer, String> partsMap, String bucket, String fileKey, String uploadId, byte[] uploadChunk, AtomicReference<IOException> exception) {
        this.requestFactory = requestFactory;
        this.partNumber = partNumber;
        this.partsMap = partsMap;
        this.bucket = bucket;
        this.fileKey = fileKey;
        this.uploadId = uploadId;
        this.uploadChunk = uploadChunk;
        this.exception = exception;
    }

    @Override
    public void run() {
        try {
            GenericUrl url = new GenericUrl(GoogleUtils.getStorageDomain() + URLEncoder.encode(this.bucket, StandardCharsets.UTF_8) + "/" + this.fileKey + "?partNumber=" + this.partNumber + "&uploadId=" + this.uploadId);
            HttpRequest uploadPartRequest = this.requestFactory.buildPutRequest(url, (HttpContent)new ByteArrayContent("application/octet-stream", this.uploadChunk));
            HttpResponse response = uploadPartRequest.execute();
            if (!response.isSuccessStatusCode()) {
                throw new IOException(response.getStatusMessage());
            }
            String etag = response.getHeaders().get((Object)"ETag").toString();
            etag = etag.substring(2, etag.length() - 2);
            this.partsMap.put(this.partNumber, etag);
        }
        catch (Throwable e) {
            this.exception.compareAndSet(null, new IOException("Failed to upload part to Google Storage", e));
        }
    }
}

