/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.google;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.graphdb.cloud.CloudMultipartDownloader;
import com.ontotext.graphdb.cloud.google.GoogleBucketOptions;
import com.ontotext.graphdb.cloud.google.GoogleChunkDownload;
import com.ontotext.graphdb.cloud.google.GoogleUtils;
import com.ontotext.license.LicenseRegistry;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCMultipartDownloader
extends CloudMultipartDownloader {
    private static final Logger logger = LoggerFactory.getLogger(GCMultipartDownloader.class);
    private final int chunksToDownload;
    private final long downloadFileSize;
    private final String downloadURL;
    private final HttpRequestFactory requestFactory;

    public GCMultipartDownloader(GoogleBucketOptions googleBucketOptions) throws IOException, GeneralSecurityException {
        this.requestFactory = this.setupRequestFactory(googleBucketOptions);
        this.downloadURL = String.format("%sdownload/storage/v1/b/%s/o/%s?alt=media", GoogleUtils.getStorageDomain(), googleBucketOptions.getBucketName(), googleBucketOptions.getFileKey());
        this.downloadFileSize = GoogleUtils.getGoogleCloudFileSize(this.downloadURL, this.requestFactory);
        this.chunksToDownload = (int)Math.ceil((double)this.downloadFileSize / (double)GoogleUtils.getMinimumPartSize());
    }

    private HttpRequestFactory setupRequestFactory(GoogleBucketOptions googleBucketOptions) throws GeneralSecurityException, IOException {
        GoogleCredentials credentials = googleBucketOptions.acquireGoogleCredentials();
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        return httpTransport.createRequestFactory((HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials));
    }

    @Override
    protected ExecutorService initDownloadingExecutor() {
        int threadCount = LicenseRegistry.getInstance().getLicensedCores(CONFIGURED_THREAD_COUNT);
        if (threadCount < 4) {
            threadCount = 1;
        }
        logger.info("Using {} threads to download a backup from Google Cloud Storage", (Object)threadCount);
        ExecutorService executor = Executors.newFixedThreadPool(threadCount, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("google-storage-download-thread-%d").build());
        for (int i = 0; i < this.chunksToDownload; ++i) {
            long chunkStart = this.chunkCounter == 0 ? 0L : (long)this.chunkCounter * (long)GoogleUtils.getMinimumPartSize();
            long chunkEnd = Math.min(chunkStart + (long)GoogleUtils.getMinimumPartSize() - 1L, this.downloadFileSize - 1L);
            if (chunkStart > this.downloadFileSize) break;
            executor.execute(new GoogleChunkDownload(this.pipedStreamsManager, this.downloadURL, this.lastChunk, ++this.chunkCounter, chunkStart, chunkEnd, this.downloadError, this.requestFactory, this.closed, this.chunksToDownload));
        }
        return executor;
    }
}

