/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.azure;

import com.azure.storage.blob.BlobClient;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.graphdb.cloud.CloudMultipartDownloader;
import com.ontotext.graphdb.cloud.azure.AzureBlobUtils;
import com.ontotext.graphdb.cloud.azure.AzureChunkDownload;
import com.ontotext.license.LicenseRegistry;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureMultipartDownloader
extends CloudMultipartDownloader {
    private static final Logger logger = LoggerFactory.getLogger(AzureMultipartDownloader.class);
    private final int chunksToDownload;
    private final long downloadFileSize;
    private final BlobClient blobClient;

    public AzureMultipartDownloader(BlobClient blobClient) throws IOException, GeneralSecurityException {
        this.blobClient = blobClient;
        this.downloadFileSize = AzureBlobUtils.getAzureFileSize(blobClient);
        this.chunksToDownload = (int)Math.ceil((double)this.downloadFileSize / (double)AzureBlobUtils.getMinimumPartSize());
    }

    @Override
    protected ExecutorService initDownloadingExecutor() {
        int threadCount = LicenseRegistry.getInstance().getLicensedCores(CONFIGURED_THREAD_COUNT);
        if (threadCount < 4) {
            threadCount = 1;
        }
        logger.info("Using {} threads to download a backup from Azure Blob Storage", (Object)threadCount);
        ExecutorService executor = Executors.newFixedThreadPool(threadCount, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("azure-download-thread-%d").build());
        for (int i = 0; i < this.chunksToDownload; ++i) {
            long chunkStart;
            long l = chunkStart = this.chunkCounter == 0 ? 0L : (long)this.chunkCounter * (long)AzureBlobUtils.getMinimumPartSize();
            if (chunkStart > this.downloadFileSize) break;
            executor.execute(new AzureChunkDownload(this.pipedStreamsManager, this.lastChunk, ++this.chunkCounter, chunkStart, this.downloadError, this.closed, this.chunksToDownload, this.blobClient));
        }
        return executor;
    }
}

