/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.azure;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.ontotext.graphdb.cloud.ChunkDownload;
import com.ontotext.graphdb.cloud.PipedStreamsManager;
import com.ontotext.graphdb.cloud.azure.AzureBlobUtils;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class AzureChunkDownload
extends ChunkDownload {
    private final long start;
    private final BlobClient blobClient;

    public AzureChunkDownload(PipedStreamsManager manager, AtomicInteger lastChunk, int chunkNumber, long start, AtomicReference<Throwable> downloadError, AtomicBoolean closed, int chunksToDownload, BlobClient blobClient) {
        super(manager, lastChunk, chunkNumber, downloadError, closed, chunksToDownload);
        this.start = start;
        this.blobClient = blobClient;
    }

    @Override
    protected byte[] downloadChunk() throws IOException {
        BlobRange range = new BlobRange(this.start, Long.valueOf(AzureBlobUtils.getMinimumPartSize()));
        try (BlobInputStream blobStream = this.blobClient.openInputStream(range, null);){
            byte[] byArray = blobStream.readAllBytes();
            return byArray;
        }
    }
}

