/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.aws;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.cloud.aws.S3BucketOptions;
import com.ontotext.license.LicenseRegistry;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.utils.StringUtils;

public class S3Utils {
    private static final Logger logger = LoggerFactory.getLogger(S3Utils.class);
    private static final int S3CLOUD_PART_MIN_SIZE = 0x2000000;
    public static final String GRAPHDB_S3CLOUD_MIN_PART_SIZE = "graphdb.s3.min.part.size";
    public static final int S3CLOUD_ESTIMATED_PART_COUNT = 9500;
    public static final long S3ClOUD_FILE_LIMIT = 5000000000000L;
    public static final String GRAPHDB_S3_TLS_ENABLED = "graphdb.s3.tls.enabled";
    public static final boolean DEFAULT_TLS_STATUS = false;
    public static final String GRAPHDB_S3_DISABLE_CHECKSUM_CHECK = "graphdb.s3.backup.disable.checksum";
    public static final boolean DEFAULT_CHECKSUM_CHECK_DISABLED = false;
    public static final String S3_DEFAULT_REGION = "us-east-1";
    public static String CONFIGURED_DEFAULT_REGION;
    public static final String HTTPCLIENT_WRITE_TIMEOUT = "graphdb.s3.backup.httpclient.write.timeout";
    public static final int DEFAULT_WRITE_TIMEOUT = 3600;
    public static final String GRAPHDB_S3_BACKUP_MAX_CONCURRENT_UPLOADS = "graphdb.s3.backup.max.concurrent.uploads";
    public static final int DEFAULT_MAX_CONCURRENT_UPLOADS = 6;
    private static final int CONFIGURED_CONCURRENT_UPLOADS;
    public static final int EXTRA_CONNECTIONS = 2;
    private static String truststoreFilePath;
    private static String truststorePassword;

    private S3Utils() {
    }

    public static S3Client s3ClientBuilder(S3BucketOptions bucketOptions, boolean isAccelerated) {
        S3ClientBuilder clientBuilder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(bucketOptions.acquireCredentialProvider())).crossRegionAccessEnabled(Boolean.valueOf(true))).region(Region.of((String)S3Utils.resolveRegion(bucketOptions.getRegion())))).accelerate(Boolean.valueOf(isAccelerated));
        if (bucketOptions.getHostAsUri() != null) {
            clientBuilder.endpointOverride(bucketOptions.getHostAsUri());
            clientBuilder.forcePathStyle(Boolean.valueOf(true));
            if (Config.getPropertyAsBoolean((String)GRAPHDB_S3_TLS_ENABLED, (boolean)false)) {
                clientBuilder.httpClientBuilder((SdkHttpClient.Builder)S3Utils.s3ClientBuilder());
            }
        }
        return (S3Client)clientBuilder.build();
    }

    public static S3AsyncClient s3AsyncClientBuilder(S3BucketOptions bucketOptions, boolean isAccelerated) {
        S3AsyncClientBuilder asyncClientBuilder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider(bucketOptions.acquireCredentialProvider())).crossRegionAccessEnabled(Boolean.valueOf(true))).region(Region.of((String)S3Utils.resolveRegion(bucketOptions.getRegion())))).accelerate(Boolean.valueOf(isAccelerated));
        if (bucketOptions.getHostAsUri() != null) {
            asyncClientBuilder.endpointOverride(bucketOptions.getHostAsUri());
            asyncClientBuilder.forcePathStyle(Boolean.valueOf(true));
            if (Config.getPropertyAsBoolean((String)GRAPHDB_S3_TLS_ENABLED, (boolean)false)) {
                asyncClientBuilder.httpClientBuilder((SdkAsyncHttpClient.Builder)S3Utils.s3AsyncClientBuilder(true));
                return (S3AsyncClient)asyncClientBuilder.build();
            }
        }
        asyncClientBuilder.httpClientBuilder((SdkAsyncHttpClient.Builder)S3Utils.s3AsyncClientBuilder(false));
        return (S3AsyncClient)asyncClientBuilder.build();
    }

    public static GetObjectRequest s3GetObjectRequestBuilder(S3BucketOptions bucketOptions) {
        return (GetObjectRequest)GetObjectRequest.builder().bucket(bucketOptions.getBucketName()).key(bucketOptions.getFileKey()).build();
    }

    public static String resolveRegion(String setRegion) {
        if (!StringUtils.isEmpty((CharSequence)setRegion)) {
            return setRegion;
        }
        logger.debug("Defaulting region to: {}", (Object)CONFIGURED_DEFAULT_REGION);
        return CONFIGURED_DEFAULT_REGION;
    }

    public static boolean checkBucketAcceleratedStatus(S3Client s3, String bucketName) {
        String status = null;
        try {
            status = s3.getBucketAccelerateConfiguration(S3Utils.s3GetBucketAccelerateStatusRequest(bucketName)).statusAsString();
        }
        catch (SdkException e) {
            logger.warn("Failed to determine bucket acceleration status: {}", (Object)e.getMessage());
        }
        return status != null && status.equalsIgnoreCase("enabled");
    }

    public static int getMaxHttpClientConcurrency() {
        return 3;
    }

    public static int getMaxConcurrentUploads() {
        int concurrentUploads = LicenseRegistry.getInstance().getLicensedCores(CONFIGURED_CONCURRENT_UPLOADS);
        if (concurrentUploads < 4) {
            return 2;
        }
        return concurrentUploads;
    }

    public static int getHttpClientWriteTimeout() {
        return Config.getPropertyAsInt((String)HTTPCLIENT_WRITE_TIMEOUT, (int)3600);
    }

    static void setDefaultRegion() {
        CONFIGURED_DEFAULT_REGION = S3_DEFAULT_REGION;
        try {
            CONFIGURED_DEFAULT_REGION = DefaultAwsRegionProviderChain.builder().build().getRegion().toString();
            logger.info("AWS SDK resolved default region to: {}", (Object)CONFIGURED_DEFAULT_REGION);
        }
        catch (SdkClientException e) {
            logger.info("AWS SDK resolved failed to resolve region, setting default to: {}", (Object)CONFIGURED_DEFAULT_REGION);
        }
    }

    private static GetBucketAccelerateConfigurationRequest s3GetBucketAccelerateStatusRequest(String bucket) {
        return (GetBucketAccelerateConfigurationRequest)GetBucketAccelerateConfigurationRequest.builder().bucket(bucket).build();
    }

    private static ApacheHttpClient.Builder s3ClientBuilder() {
        if (truststoreFilePath == null) {
            return ApacheHttpClient.builder();
        }
        try {
            return ApacheHttpClient.builder().tlsTrustManagersProvider(S3Utils.customTrustManagerProvider());
        }
        catch (Exception e) {
            logger.warn("Failed to load provided truststore: {}, {} \nAttempting to use default.", (Object)truststoreFilePath, (Object)e.getMessage());
            return ApacheHttpClient.builder();
        }
    }

    private static NettyNioAsyncHttpClient.Builder s3AsyncClientBuilder(boolean withTls) {
        NettyNioAsyncHttpClient.Builder httpClientBuilder = NettyNioAsyncHttpClient.builder().writeTimeout(Duration.ofSeconds(S3Utils.getHttpClientWriteTimeout())).maxConcurrency(Integer.valueOf(S3Utils.getMaxHttpClientConcurrency()));
        if (truststoreFilePath == null) {
            return httpClientBuilder;
        }
        if (withTls) {
            try {
                return httpClientBuilder.tlsTrustManagersProvider(S3Utils.customTrustManagerProvider());
            }
            catch (Exception e) {
                logger.warn("Failed to load provided truststore: {}, {} \nAttempting to use default.", (Object)truststoreFilePath, (Object)e.getMessage());
            }
        }
        return httpClientBuilder;
    }

    private static TlsTrustManagersProvider customTrustManagerProvider() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore truststore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream truststoreFileStream = new FileInputStream(truststoreFilePath);){
            truststore.load(truststoreFileStream, truststorePassword.toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(truststore);
        return trustManagerFactory::getTrustManagers;
    }

    @VisibleForTesting
    public static void setTruststore() {
        truststoreFilePath = Config.getProperty((String)"graphdb.connector.truststoreFile");
        truststorePassword = Config.getProperty((String)"graphdb.connector.truststorePass");
    }

    public static int getMinimumPartSize() {
        return Config.getPropertyAsInt((String)GRAPHDB_S3CLOUD_MIN_PART_SIZE, (int)0x2000000);
    }

    public static long getS3FileSize(S3AsyncClient s3Client, S3BucketOptions bucketOptions) throws ExecutionException, InterruptedException, IOException {
        HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketOptions.getBucketName()).key(bucketOptions.getFileKey()).build();
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)s3Client.headObject(headObjectRequest).get();
        long fileSize = headObjectResponse.contentLength();
        if (fileSize > 0L) {
            return fileSize;
        }
        throw new IOException("Invalid backup file size: " + fileSize);
    }

    static {
        truststoreFilePath = Config.getProperty((String)"graphdb.connector.truststoreFile");
        truststorePassword = Config.getProperty((String)"graphdb.connector.truststorePass");
        int uploads = Config.getPropertyAsInt((String)GRAPHDB_S3_BACKUP_MAX_CONCURRENT_UPLOADS, (int)6);
        if (uploads > 16 || uploads < 1) {
            logger.warn("Invalid upload count for s3 upload \"{}\", switching to default value {}", (Object)uploads, (Object)6);
            uploads = 6;
        }
        CONFIGURED_CONCURRENT_UPLOADS = uploads;
        S3Utils.setDefaultRegion();
    }
}

