/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.aws;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

public class S3PartUpload
implements Runnable {
    private final int partNumber;
    private final List<CompletedPart> parts;
    private final S3AsyncClient s3;
    private final String bucket;
    private final String fileKey;
    private final String uploadId;
    private final byte[] uploadChunk;
    private final AtomicReference<IOException> exception;
    private final boolean enableChecksumCheck;

    public S3PartUpload(S3AsyncClient s3, boolean enableChecksumCheck, int partNumber, List<CompletedPart> parts, String bucket, String fileKey, String uploadId, byte[] uploadChunk, AtomicReference<IOException> exception) {
        this.s3 = s3;
        this.enableChecksumCheck = enableChecksumCheck;
        this.partNumber = partNumber;
        this.parts = parts;
        this.bucket = bucket;
        this.fileKey = fileKey;
        this.uploadId = uploadId;
        this.uploadChunk = uploadChunk;
        this.exception = exception;
    }

    @Override
    public void run() {
        try {
            UploadPartRequest.Builder uploadPartRequestBuilder = UploadPartRequest.builder().bucket(this.bucket).key(this.fileKey).uploadId(this.uploadId).partNumber(Integer.valueOf(this.partNumber));
            if (this.enableChecksumCheck) {
                uploadPartRequestBuilder.checksumAlgorithm(ChecksumAlgorithm.SHA1);
            }
            UploadPartResponse future = (UploadPartResponse)this.s3.uploadPart((UploadPartRequest)uploadPartRequestBuilder.build(), AsyncRequestBody.fromBytes((byte[])this.uploadChunk)).get();
            CompletedPart.Builder completedPartBuilder = CompletedPart.builder().partNumber(Integer.valueOf(this.partNumber)).eTag(future.eTag());
            if (this.enableChecksumCheck) {
                completedPartBuilder.checksumSHA1(future.checksumSHA1());
            }
            this.parts.add((CompletedPart)completedPartBuilder.build());
        }
        catch (Throwable e) {
            this.exception.compareAndSet(null, new IOException("Failed to upload part to s3", e));
        }
    }
}

