/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.aws;

import com.ontotext.graphdb.cloud.ChunkDownload;
import com.ontotext.graphdb.cloud.PipedStreamsManager;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

public class S3ChunkDownload
extends ChunkDownload {
    private final long start;
    private final long end;
    private final String bucketName;
    private final String fileKey;
    private final S3AsyncClient s3Client;

    public S3ChunkDownload(PipedStreamsManager manager, AtomicInteger lastChunk, int chunkNumber, long start, long end, String bucketName, String fileKey, S3AsyncClient s3Client, AtomicReference<Throwable> downloadError, AtomicBoolean closed, int chunksToDownload) {
        super(manager, lastChunk, chunkNumber, downloadError, closed, chunksToDownload);
        this.start = start;
        this.end = end;
        this.bucketName = bucketName;
        this.fileKey = fileKey;
        this.s3Client = s3Client;
    }

    @Override
    protected byte[] downloadChunk() throws ExecutionException, InterruptedException {
        GetObjectRequest objectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(this.fileKey).range("bytes=" + this.start + "-" + this.end).build();
        return ((ResponseBytes)this.s3Client.getObject(objectRequest, AsyncResponseTransformer.toBytes()).get()).asByteArray();
    }
}

