/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud;

import com.ontotext.graphdb.cloud.PipedStreamsManager;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChunkDownload
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ChunkDownload.class);
    private final int chunkNumber;
    private final int chunksToDownload;
    private final AtomicInteger lastChunk;
    private final AtomicReference<Throwable> downloadError;
    private final AtomicBoolean closed;
    private final PipedStreamsManager manager;
    private final int previousChunk;

    public ChunkDownload(PipedStreamsManager manager, AtomicInteger lastChunk, int chunkNumber, AtomicReference<Throwable> downloadError, AtomicBoolean closed, int chunksToDownload) {
        this.chunkNumber = chunkNumber;
        this.chunksToDownload = chunksToDownload;
        this.lastChunk = lastChunk;
        this.downloadError = downloadError;
        this.closed = closed;
        this.manager = manager;
        this.previousChunk = chunkNumber - 1;
    }

    @Override
    public void run() {
        try {
            if (!this.closed.get() && this.downloadError.get() == null) {
                byte[] chunk = this.downloadChunk();
                this.writeChunkToInputStream(chunk);
                this.lastChunk.set(this.chunkNumber);
            }
        }
        catch (Throwable e) {
            this.downloadError.compareAndSet(null, new IOException("Failed to download chunk from cloud", e));
        }
        finally {
            if (this.chunkNumber == this.chunksToDownload) {
                try {
                    this.manager.closeOutputStream();
                }
                catch (IOException e) {
                    this.downloadError.compareAndSet(null, new IOException("Failed to close output stream", e));
                }
            }
        }
    }

    protected abstract byte[] downloadChunk() throws ExecutionException, IOException, InterruptedException;

    private void writeChunkToInputStream(byte[] chunk) throws IOException {
        while (this.lastChunk.get() != this.previousChunk) {
            if (this.downloadError.get() != null || this.closed.get() || Thread.currentThread().isInterrupted()) {
                logger.debug("Skipped writing chunk {}", (Object)this.chunkNumber);
                return;
            }
            Thread.onSpinWait();
        }
        this.manager.getOutputStream().write(chunk);
    }
}

