/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.rule.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.moandjiezana.toml.Toml;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInvalidKGQueryException;
import it.unibz.inf.ontop.exception.OntopUnsupportedKGQueryException;
import it.unibz.inf.ontop.exception.SparqlRuleException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.query.KGQueryFactory;
import it.unibz.inf.ontop.query.translation.KGQueryTranslator;
import it.unibz.inf.ontop.spec.OBDASpecInput;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.rule.RuleExtractor;
import it.unibz.inf.ontop.spec.rule.impl.IntensionalNodeExtractor;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

@Singleton
public class RuleExtractorImpl
implements RuleExtractor {
    private static final String RULES_KEY = "rules";
    private final KGQueryFactory kgQueryFactory;
    private final KGQueryTranslator kgQueryTranslator;
    private final IntensionalNodeExtractor intensionalNodeExtractor;

    @Inject
    protected RuleExtractorImpl(KGQueryFactory kgQueryFactory, KGQueryTranslator kgQueryTranslator, IntensionalNodeExtractor intensionalNodeExtractor) {
        this.kgQueryFactory = kgQueryFactory;
        this.kgQueryTranslator = kgQueryTranslator;
        this.intensionalNodeExtractor = intensionalNodeExtractor;
    }

    @Override
    public ImmutableList<IQ> extract(OBDASpecInput specInput) throws SparqlRuleException {
        try {
            Optional<Reader> reader = specInput.getSparqlRulesReader();
            if (!reader.isPresent()) {
                return ImmutableList.of();
            }
            return this.order(this.parse(reader.get()));
        }
        catch (FileNotFoundException e) {
            throw new SparqlRuleException(e);
        }
    }

    protected ImmutableSet<IQ> parse(Reader sparqlRulesReader) throws SparqlRuleException {
        List ruleStrings;
        Toml toml;
        try {
            toml = new Toml().read(sparqlRulesReader);
        }
        catch (RuntimeException e) {
            throw new SparqlRuleException(e);
        }
        if (!toml.contains(RULES_KEY)) {
            throw new SparqlRuleException("Invalid SPARQL rules: was expecting the key \"rules\"");
        }
        try {
            ruleStrings = toml.getList(RULES_KEY);
            if (!ruleStrings.stream().allMatch(Objects::nonNull)) {
                throw new SparqlRuleException("Invalid SPARQL rules: Was expecting a list of non-null strings for the key \"rules\"");
            }
        }
        catch (ClassCastException e) {
            throw new SparqlRuleException("Invalid SPARQL rules: Was expecting a list of strings for the key \"rules\"");
        }
        ImmutableSet.Builder ruleSetBuilder = ImmutableSet.builder();
        for (String ruleString : ruleStrings) {
            ruleSetBuilder.addAll(this.parseSparqlRule(ruleString));
        }
        return ruleSetBuilder.build();
    }

    private ImmutableSet<IQ> parseSparqlRule(String ruleString) throws SparqlRuleException {
        try {
            return this.kgQueryFactory.createInsertQuery(ruleString).translate(this.kgQueryTranslator);
        }
        catch (OntopInvalidKGQueryException | OntopUnsupportedKGQueryException e) {
            throw new SparqlRuleException((Exception)e);
        }
    }

    protected ImmutableList<IQ> order(ImmutableSet<IQ> rules) throws SparqlRuleException {
        if (rules.size() <= 1) {
            return ImmutableList.copyOf(rules);
        }
        ImmutableMultimap<IQ, IQ> directDependencyMultimap = this.extractDirectDependencyMultimap(rules);
        if (directDependencyMultimap.isEmpty()) {
            return ImmutableList.copyOf(rules);
        }
        Map<IQ, Set<IQ>> saturatedDependencyMap = this.saturate(directDependencyMultimap);
        this.checkForCycles(saturatedDependencyMap);
        ImmutableMap dependencyCount = (ImmutableMap)rules.stream().collect(ImmutableCollectors.toMap(r -> r, r -> ((Set)saturatedDependencyMap.getOrDefault(r, (Set<IQ>)ImmutableSet.of())).size()));
        return (ImmutableList)rules.stream().sorted(Comparator.comparing(arg_0 -> ((ImmutableMap)dependencyCount).get(arg_0))).collect(ImmutableCollectors.toList());
    }

    private ImmutableMultimap<IQ, IQ> extractDirectDependencyMultimap(ImmutableSet<IQ> rules) throws SparqlRuleException {
        ImmutableMultimap<IRI, IQ> definitions = this.extractedIndexByOutputPredicate(rules);
        ImmutableMultimap.Builder multimapBuilder = ImmutableMultimap.builder();
        for (IQ rule : rules) {
            for (IRI iri : this.extractDependencyPredicates(rule)) {
                for (IQ dependency : definitions.get((Object)iri)) {
                    multimapBuilder.put((Object)rule, (Object)dependency);
                }
            }
        }
        return multimapBuilder.build();
    }

    private ImmutableMultimap<IRI, IQ> extractedIndexByOutputPredicate(ImmutableSet<IQ> rules) throws SparqlRuleException {
        ImmutableMultimap.Builder multimapBuilder = ImmutableMultimap.builder();
        for (IQ rule : rules) {
            try {
                IRI iri = new MappingAssertion(rule, null).getIndex().getIri();
                multimapBuilder.put((Object)iri, (Object)rule);
            }
            catch (MappingAssertion.NoGroundPredicateOntopInternalBugException e) {
                throw new SparqlRuleException("Unsupported rule: must use a constant class or a constant non-rdf:type property in the INSERT clause.\n" + rule);
            }
        }
        return multimapBuilder.build();
    }

    private ImmutableSet<IRI> extractDependencyPredicates(IQ rule) throws SparqlRuleException {
        ImmutableList dependencyAtoms = (ImmutableList)((Stream)rule.getTree().acceptVisitor((IQVisitor)this.intensionalNodeExtractor)).map(IntensionalDataNode::getProjectionAtom).collect(ImmutableCollectors.toList());
        ImmutableSet.Builder predicateBuilder = ImmutableSet.builder();
        for (DataAtom atom : dependencyAtoms) {
            predicateBuilder.add((Object)this.extractPredicate((DataAtom<AtomPredicate>)atom, rule));
        }
        return predicateBuilder.build();
    }

    private IRI extractPredicate(DataAtom<AtomPredicate> atom, IQ rule) throws SparqlRuleException {
        AtomPredicate predicate = atom.getPredicate();
        if (predicate instanceof RDFAtomPredicate) {
            return (IRI)((RDFAtomPredicate)predicate).getPredicateIRI(atom.getArguments()).orElseThrow(() -> new SparqlRuleException("All the triple/quad patterns must have a constant class or a constant non-rdf:type property.\nUnsupported rule: " + rule));
        }
        throw new MinorOntopInternalBugException("Non RDFAtomPredicate found for an IQ rule");
    }

    private Map<IQ, Set<IQ>> saturate(ImmutableMultimap<IQ, IQ> directDependencyMultimap) {
        Map<IQ, Set<IQ>> map = directDependencyMultimap.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Sets.newHashSet((Iterable)((Iterable)e.getValue()))));
        boolean hasNotConverged = true;
        while (hasNotConverged) {
            hasNotConverged = false;
            for (Map.Entry<IQ, Set<IQ>> entry : map.entrySet()) {
                Set<IQ> mutableDependencySet = entry.getValue();
                ImmutableSet currentDependencies = ImmutableSet.copyOf((Collection)entry.getValue());
                for (IQ dependency : currentDependencies) {
                    Set<IQ> inheritedDependencies = map.get(dependency);
                    if (inheritedDependencies == null) continue;
                    boolean hasChanged = mutableDependencySet.addAll(inheritedDependencies);
                    hasNotConverged = hasNotConverged || hasChanged;
                }
            }
        }
        return map;
    }

    private void checkForCycles(Map<IQ, Set<IQ>> saturatedDependencyMap) throws SparqlRuleException {
        ImmutableSet rulesInCycles = (ImmutableSet)saturatedDependencyMap.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(e.getKey())).map(Map.Entry::getKey).map(Object::toString).collect(ImmutableCollectors.toSet());
        if (!rulesInCycles.isEmpty()) {
            throw new SparqlRuleException("Dependency cycles detected for the following rules: \n" + String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)rulesInCycles));
        }
    }
}

