/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.rule.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractIntensionalQueryMerger;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;

public class MutableQueryUnfolder
extends AbstractIntensionalQueryMerger {
    private final Map<MappingAssertionIndex, MappingAssertion> mutableMapping;
    private final SubstitutionFactory substitutionFactory;
    private final QueryTransformerFactory transformerFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    private final AtomFactory atomFactory;

    public MutableQueryUnfolder(Map<MappingAssertionIndex, MappingAssertion> mutableMapping, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, QueryTransformerFactory transformerFactory, CoreUtilsFactory coreUtilsFactory, AtomFactory atomFactory) {
        super(iqFactory);
        this.mutableMapping = mutableMapping;
        this.substitutionFactory = substitutionFactory;
        this.transformerFactory = transformerFactory;
        this.coreUtilsFactory = coreUtilsFactory;
        this.atomFactory = atomFactory;
    }

    protected AbstractIntensionalQueryMerger.QueryMergingTransformer createTransformer(ImmutableSet<Variable> knownVariables) {
        return new MutableQueryUnfoldingTransformer(this.coreUtilsFactory.createVariableGenerator(knownVariables), this.iqFactory);
    }

    protected class MutableQueryUnfoldingTransformer
    extends AbstractIntensionalQueryMerger.QueryMergingTransformer {
        protected MutableQueryUnfoldingTransformer(VariableGenerator variableGenerator, IntermediateQueryFactory iqFactory) {
            super(variableGenerator, iqFactory, MutableQueryUnfolder.this.substitutionFactory, MutableQueryUnfolder.this.atomFactory, MutableQueryUnfolder.this.transformerFactory);
        }

        protected Optional<IQ> getDefinition(IntensionalDataNode dataNode) {
            DataAtom atom = dataNode.getProjectionAtom();
            return Optional.of(atom).map(DataAtom::getPredicate).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).flatMap(p -> this.getDefinition((RDFAtomPredicate)p, (ImmutableList<? extends VariableOrGroundTerm>)atom.getArguments()));
        }

        private Optional<IQ> getDefinition(RDFAtomPredicate predicate, ImmutableList<? extends VariableOrGroundTerm> arguments) {
            return predicate.getPropertyIRI(arguments).map(i -> i.equals((Object)RDF.TYPE) ? this.getRDFClassDefinition(predicate, arguments) : this.getRDFPropertyDefinition(predicate, (IRI)i)).orElseGet(() -> this.getStarDefinition(predicate));
        }

        private Optional<IQ> getRDFPropertyDefinition(RDFAtomPredicate predicate, IRI iri) {
            return Optional.ofNullable(MutableQueryUnfolder.this.mutableMapping.get(MappingAssertionIndex.ofProperty(predicate, iri))).map(MappingAssertion::getQuery);
        }

        private Optional<IQ> getRDFClassDefinition(RDFAtomPredicate predicate, ImmutableList<? extends VariableOrGroundTerm> arguments) {
            return predicate.getClassIRI(arguments).map(i -> this.getRDFClassDefinition(predicate, (IRI)i)).orElseGet(() -> this.getStarClassDefinition(predicate));
        }

        private Optional<IQ> getRDFClassDefinition(RDFAtomPredicate predicate, IRI iri) {
            return Optional.ofNullable(MutableQueryUnfolder.this.mutableMapping.get(MappingAssertionIndex.ofClass(predicate, iri))).map(MappingAssertion::getQuery);
        }

        private Optional<IQ> getStarClassDefinition(RDFAtomPredicate predicate) {
            throw new MinorOntopInternalBugException("Triple/quad patterns where the class or the non-rdf-type property are not specified are not supported for SPARQL INSERT rules");
        }

        private Optional<IQ> getStarDefinition(RDFAtomPredicate predicate) {
            throw new MinorOntopInternalBugException("Triple/quad patterns where the class or the non-rdf-type property are not specified are not supported for SPARQL INSERT rules");
        }

        protected IQTree handleIntensionalWithoutDefinition(IntensionalDataNode dataNode) {
            return this.iqFactory.createEmptyNode(dataNode.getVariables());
        }
    }
}

