/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.AbstractRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.LensImpl;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.impl.AtomPredicateImpl;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingValuesWrapper;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.UUID;
import java.util.stream.IntStream;

public class MappingValuesWrapperImpl
implements MappingValuesWrapper {
    private final OntopMappingSettings settings;

    @Inject
    protected MappingValuesWrapperImpl(OntopMappingSettings settings) {
        this.settings = settings;
    }

    @Override
    public ImmutableList<MappingAssertion> normalize(ImmutableList<MappingAssertion> mapping, DBParameters dbParameters) {
        if (this.settings.isValuesNodesWrapInLensesInMappingEnabled()) {
            Transformer transformer = new Transformer(dbParameters);
            return (ImmutableList)mapping.stream().map(transformer::transformMappingAssertion).collect(ImmutableCollectors.toList());
        }
        return mapping;
    }

    protected static class TemporaryLensPredicate
    extends AtomPredicateImpl {
        protected TemporaryLensPredicate(String name, ImmutableList<TermType> baseTypesForValidation) {
            super(name, baseTypesForValidation);
        }
    }

    protected static class Transformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final QuotedIDFactory rawQuotedIqFactory;
        private final DBParameters dbParameters;
        private final AtomFactory atomFactory;

        protected Transformer(DBParameters dbParameters) {
            super(dbParameters.getCoreSingletons());
            this.dbParameters = dbParameters;
            this.rawQuotedIqFactory = new RawQuotedIDFactory(dbParameters.getQuotedIDFactory());
            this.atomFactory = dbParameters.getCoreSingletons().getAtomFactory();
        }

        public IQTree transformValues(ValuesNode valuesNode) {
            ImmutableSet uniqueConstraints = valuesNode.inferUniqueConstraints();
            if (uniqueConstraints.isEmpty()) {
                return valuesNode;
            }
            RelationID relationId = this.rawQuotedIqFactory.createRelationID("(" + valuesNode + ")");
            ImmutableList orderedVariables = valuesNode.getOrderedVariables();
            int arity = orderedVariables.size();
            DistinctVariableOnlyDataAtom projectionAtom = this.atomFactory.getDistinctVariableOnlyDataAtom(this.createTemporaryPredicate(relationId, arity, this.dbParameters.getCoreSingletons()), orderedVariables);
            IQ newIQ = this.iqFactory.createIQ(projectionAtom, (IQTree)valuesNode);
            RelationDefinition.AttributeListBuilder attributeBuilder = this.createAttributeBuilder(newIQ, this.dbParameters);
            LensImpl lens = new LensImpl(ImmutableList.of((Object)relationId), attributeBuilder, newIQ, 1, this.dbParameters.getCoreSingletons());
            uniqueConstraints.forEach(arg_0 -> this.lambda$transformValues$0((Lens)lens, orderedVariables, arg_0));
            return this.iqFactory.createExtensionalDataNode((RelationDefinition)lens, (ImmutableMap)IntStream.range(0, arity).mapToObj(i -> Maps.immutableEntry((Object)i, (Object)((Variable)orderedVariables.get(i)))).collect(ImmutableCollectors.toMap()));
        }

        private void insertUniqueConstraints(Lens lens, ImmutableSet<Variable> uniqueConstraint, ImmutableList<Variable> orderedVariables) {
            FunctionalDependency.Builder builder = UniqueConstraint.builder((NamedRelationDefinition)lens, (String)("uc" + UUID.randomUUID()));
            uniqueConstraint.stream().map(v -> orderedVariables.indexOf(v) + 1).forEach(arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
            builder.build();
        }

        protected RelationDefinition.AttributeListBuilder createAttributeBuilder(IQ iq, DBParameters dbParameters) {
            SingleTermTypeExtractor uniqueTermTypeExtractor = dbParameters.getCoreSingletons().getUniqueTermTypeExtractor();
            RelationDefinition.AttributeListBuilder builder = AbstractRelationDefinition.attributeListBuilder();
            IQTree iqTree = iq.getTree();
            VariableNullability variableNullability = iqTree.getVariableNullability();
            DBTermType rootType = dbParameters.getDBTypeFactory().getAbstractRootDBType();
            for (Variable v : iq.getProjectionAtom().getArguments()) {
                QuotedID attributeId = this.rawQuotedIqFactory.createAttributeID(v.getName());
                TermType inferredType = (TermType)uniqueTermTypeExtractor.extractSingleTermType((ImmutableTerm)v, iqTree).orElse(rootType);
                DBTermType datatype = inferredType instanceof DBTermType ? (DBTermType)inferredType : rootType;
                builder.addAttribute(attributeId, datatype, variableNullability.isPossiblyNullable(v));
            }
            return builder;
        }

        protected AtomPredicate createTemporaryPredicate(RelationID relationId, int arity, CoreSingletons coreSingletons) {
            DBTermType dbRootType = coreSingletons.getTypeFactory().getDBTypeFactory().getAbstractRootDBType();
            return new TemporaryLensPredicate(relationId.getSQLRendering(), (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).mapToObj(i -> dbRootType).collect(ImmutableCollectors.toList())));
        }

        public MappingAssertion transformMappingAssertion(MappingAssertion mappingAssertion) {
            IQ initialIQ = mappingAssertion.getQuery();
            IQTree initialTree = initialIQ.getTree();
            IQTree newTree = this.transform(initialTree);
            return newTree.equals(initialTree) ? mappingAssertion : new MappingAssertion(this.iqFactory.createIQ(initialIQ.getProjectionAtom(), newTree), mappingAssertion.getProvenance());
        }

        private /* synthetic */ void lambda$transformValues$0(Lens lens, ImmutableList orderedVariables, ImmutableSet uc) {
            this.insertUniqueConstraints(lens, (ImmutableSet<Variable>)uc, (ImmutableList<Variable>)orderedVariables);
        }
    }
}

