/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.substitution.Substitution;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;

public class TargetAtomImpl
implements TargetAtom {
    protected final DistinctVariableOnlyDataAtom atom;
    protected final Substitution<ImmutableTerm> substitution;

    protected TargetAtomImpl(DistinctVariableOnlyDataAtom atom, Substitution<ImmutableTerm> substitution) {
        this.atom = atom;
        this.substitution = substitution;
    }

    @Override
    public DistinctVariableOnlyDataAtom getProjectionAtom() {
        return this.atom;
    }

    @Override
    public Substitution<ImmutableTerm> getSubstitution() {
        return this.substitution;
    }

    @Override
    public ImmutableTerm getSubstitutedTerm(int index) {
        return this.substitution.apply(this.atom.getTerm(index));
    }

    @Override
    public ImmutableList<ImmutableTerm> getSubstitutedTerms() {
        return this.substitution.apply(this.atom.getArguments());
    }

    @Override
    public Optional<IRI> getPredicateIRI() {
        return Optional.of(this.atom.getPredicate()).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).flatMap(p -> p.getPredicateIRI(this.getSubstitutedTerms()));
    }

    public String toString() {
        return this.atom.toString() + " with " + this.substitution.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof TargetAtomImpl) {
            TargetAtomImpl targetAtom = (TargetAtomImpl)other;
            return this.atom.equals(targetAtom.atom) && this.substitution.equals(targetAtom.substitution);
        }
        return false;
    }
}

