/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping;

import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;

public class MappingAssertionIndex {
    private final boolean isClass;
    private final Optional<IRI> iri;
    private final RDFAtomPredicate predicate;

    private MappingAssertionIndex(RDFAtomPredicate predicate, Optional<IRI> iri, boolean isClass) {
        this.predicate = Objects.requireNonNull(predicate);
        this.iri = iri;
        this.isClass = isClass;
    }

    public static MappingAssertionIndex ofProperty(RDFAtomPredicate predicate, Optional<IRI> iri) {
        return new MappingAssertionIndex(predicate, iri, false);
    }

    public static MappingAssertionIndex ofClass(RDFAtomPredicate predicate, Optional<IRI> iri) {
        return new MappingAssertionIndex(predicate, iri, true);
    }

    public static MappingAssertionIndex ofProperty(RDFAtomPredicate predicate, IRI iri) {
        return new MappingAssertionIndex(predicate, Optional.of(iri), false);
    }

    public static MappingAssertionIndex ofClass(RDFAtomPredicate predicate, IRI iri) {
        return new MappingAssertionIndex(predicate, Optional.of(iri), true);
    }

    public boolean isClass() {
        return this.isClass;
    }

    public IRI getIri() {
        return this.iri.orElseThrow(() -> new MappingAssertion.NoGroundPredicateOntopInternalBugException("The definition of the predicate is not always a ground term"));
    }

    public RDFAtomPredicate getPredicate() {
        return this.predicate;
    }

    public int hashCode() {
        return Objects.hash(this.iri, this.predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MappingAssertionIndex) {
            MappingAssertionIndex other = (MappingAssertionIndex)o;
            return this.predicate.equals(other.predicate) && this.iri.equals(other.iri) && this.isClass == other.isClass;
        }
        return false;
    }

    public String toString() {
        return this.predicate + ":" + (this.isClass ? "C/" : "P/") + this.iri;
    }
}

