/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clusterproxy;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.http.DefaultHttpClientProvider;
import com.ontotext.graphdb.raft.security.SecurityConfig;
import com.ontotext.trree.util.HttpClientUtil;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.stereotype.Component;

@Component
public class GraphDbHttpClientProvider
extends DefaultHttpClientProvider {
    protected HttpClientBuilder createHttpClient() {
        return HttpClientUtil.createHttpClientBuilder((int)this.getSocketTimeout(), (int)this.getConnectionTimeout(), (int)this.getMaxConnectionsPerRoute(), (int)this.getMaxConnectionsTotal(), (int)this.getSocketSoTimeout());
    }

    public boolean isTlsEnabled() {
        return SecurityConfig.INSTANCE.isSecurityEnabled();
    }

    protected int getSocketTimeout() {
        return Config.getPropertyAsInt((String)"graphdb.cluster.proxy.socketTimeout", (int)-1);
    }

    protected int getMaxConnectionsTotal() {
        return Config.getPropertyAsInt((String)"graphdb.cluster.proxy.maxConnectionsTotal", (int)50000);
    }

    protected int getMaxConnectionsPerRoute() {
        return Config.getPropertyAsInt((String)"graphdb.cluster.proxy.maxConnectionsPerRoute", (int)30000);
    }

    protected int getConnectionTimeout() {
        return (int)TimeUnit.SECONDS.toMillis(Config.getPropertyAsInt((String)"graphdb.cluster.proxy.connectionTimeoutS", (int)15));
    }

    protected int getSocketSoTimeout() {
        return (int)TimeUnit.SECONDS.toMillis(Config.getPropertyAsInt((String)"graphdb.cluster.proxy.socket.soTimeout", (int)this.getDefaultSocketSoTimeout()));
    }
}

