/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clusterproxy;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.clusterproxy.EmbeddedProxyUriRouter;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.http.ClusterAddressResolver;
import com.ontotext.graphdb.http.RequestFilter;
import com.ontotext.graphdb.raft.NodeState;
import com.ontotext.graphdb.raft.observe.RaftObserver;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmbeddedProxyAddressResolver
implements ClusterAddressResolver,
RaftObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int electionGracePeriod = Config.getPropertyAsInt((String)"graphdb.cluster.proxy.electionGracePeriodMillis", (int)10000);
    private AtomicReference<NodeState> nodeState = new AtomicReference<NodeState>(NodeState.NO_CLUSTER);
    private AtomicReference<String> leader = new AtomicReference();
    private AtomicReference<CountDownLatch> leaderElected = new AtomicReference();
    private AtomicLong lastElection = new AtomicLong();

    public RequestFilter getCustomFilter() {
        return EmbeddedProxyUriRouter.getInstance();
    }

    public URI resolveRandomNode() {
        throw new UnsupportedOperationException();
    }

    public URI resolveReadNode() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public URI resolveWriteNode() {
        if (this.isLeaderInternal()) {
            throw new IllegalStateException("Cannot proxy to itself");
        }
        String leaderAddress = this.waitForLeader();
        if (leaderAddress == null) {
            return null;
        }
        return URI.create(leaderAddress);
    }

    @Nullable
    private String waitForLeader() {
        String leaderAddress;
        while ((leaderAddress = this.getLeader()) == null && !this.isCandidateForAwhile()) {
            Thread.onSpinWait();
        }
        return leaderAddress;
    }

    public ClusterAddressResolver.DeploymentType getDeploymentType() {
        return ClusterAddressResolver.DeploymentType.EMBEDDED;
    }

    public boolean isLeader() {
        if (!this.clusterEnabled()) {
            return true;
        }
        if (this.isLeaderInternal()) {
            return true;
        }
        this.waitForLeader();
        return this.isLeaderInternal();
    }

    private void awaitLeaderElection() {
        CountDownLatch latch = this.leaderElected.get();
        if (latch != null && !this.isCandidateForAwhile()) {
            try {
                if (this.awaitElection(latch)) {
                    LOGGER.info("Leader elected");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean isCandidateForAwhile() {
        if (this.nodeState.get() == NodeState.CANDIDATE) {
            long electionTimestamp = this.lastElection.get();
            if (electionTimestamp < 0L) {
                return true;
            }
            if (electionTimestamp == 0L) {
                return false;
            }
            if (System.currentTimeMillis() - electionTimestamp > (long)this.getElectionGracePeriod() && this.lastElection.compareAndSet(electionTimestamp, -1L)) {
                LOGGER.warn("Leader not elected in time");
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    boolean awaitElection(CountDownLatch latch) throws InterruptedException {
        long electionTime = this.lastElection.get();
        if (electionTime < 0L) {
            return false;
        }
        if (electionTime > 0L) {
            long elapsedTime = System.currentTimeMillis() - electionTime;
            if (elapsedTime >= (long)this.getElectionGracePeriod()) {
                return false;
            }
            return latch.await((long)this.getElectionGracePeriod() - elapsedTime, TimeUnit.MILLISECONDS);
        }
        return latch.await(this.getElectionGracePeriod(), TimeUnit.MILLISECONDS);
    }

    public int getElectionGracePeriod() {
        return this.electionGracePeriod;
    }

    public void update(NodeState state) {
        LOGGER.info("Changed node state to: {}", (Object)state);
        NodeState previousState = this.nodeState.getAndSet(state);
        if (state == NodeState.CANDIDATE) {
            if (previousState != NodeState.CANDIDATE || this.lastElection.get() == 0L) {
                this.lastElection.compareAndSet(0L, System.currentTimeMillis());
            }
        } else {
            this.lastElection.set(0L);
        }
    }

    public void update(String leaderRpcAddress, String leaderHttpAddress) {
        this.leader.set(StringUtils.trimToNull((String)leaderHttpAddress));
        if (this.leader.get() != null) {
            LOGGER.info("Changed cluster leader to {}", (Object)leaderHttpAddress);
            this.updateElectedCondition();
        } else {
            this.leaderElected.compareAndSet(null, new CountDownLatch(1));
        }
    }

    public void update(long term) {
    }

    private void updateElectedCondition() {
        this.lastElection.set(0L);
        CountDownLatch latch = this.leaderElected.get();
        if (latch != null) {
            latch.countDown();
            if (latch.getCount() == 0L) {
                this.leaderElected.set(null);
            }
        }
    }

    boolean clusterEnabled() {
        return this.nodeState.get() != NodeState.NO_CLUSTER;
    }

    boolean isLeaderInternal() {
        NodeState state = this.nodeState.get();
        return state == NodeState.LEADER || state == NodeState.RESTRICTED || this.isCandidateForAwhile() || this.isNodeOutOfSyncAndNoLeader();
    }

    String getLeader() {
        this.awaitLeaderElection();
        return this.leader.get();
    }

    boolean isNodeOutOfSyncAndNoLeader() {
        return this.leader.get() == null && this.nodeState.get() == NodeState.OUT_OF_SYNC;
    }
}

