/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clustermanagement;

import com.google.protobuf.ByteString;
import com.google.protobuf.GraphDBByteString;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBStateReport;
import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.grpc.ReportData;
import com.ontotext.graphdb.raft.grpc.ReportRequest;
import com.ontotext.graphdb.raft.grpc.ReportServiceGrpc;
import com.ontotext.graphdb.raft.util.RpcOutputStream;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SystemReportService
extends ReportServiceGrpc.ReportServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger(SystemReportService.class);
    private final int messageSize = Config.getPropertyAsInt((String)"graphdb.raft.rpc.message.size", (int)ClusterGroup.MESSAGE_SIZE_KB_DEFAULT) * 1024;
    private final int reportCache = Config.getPropertyAsInt((String)"graphdb.cluster.node.report.staleAfterSeconds", (int)60);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSystemReport(ReportRequest request, StreamObserver<ReportData> responseObserver) {
        GraphDBStateReport graphDBReporter = this.getGraphDBStateReport();
        try {
            if (graphDBReporter.hasReport()) {
                Path reportFile = graphDBReporter.getLastReportFile();
                FileTime lastModifiedTime = Files.getLastModifiedTime(reportFile, new LinkOption[0]);
                if (System.currentTimeMillis() - lastModifiedTime.toMillis() > TimeUnit.SECONDS.toMillis(this.reportCache)) {
                    logger.info("Generating new report as the previous report was generated more than {} seconds ago at {}", (Object)this.reportCache, (Object)lastModifiedTime.toInstant());
                    this.generateReport(graphDBReporter);
                }
            } else if (!graphDBReporter.hasReport()) {
                this.generateReport(graphDBReporter);
            }
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)graphDBReporter);
            responseObserver.onError((Throwable)e);
            return;
        }
        RpcOutputStream stream = new RpcOutputStream(responseObserver, this.messageSize, byteData -> ReportData.newBuilder().setData((ByteString)new GraphDBByteString(byteData)).build());
        try {
            graphDBReporter.writeReportToStream((OutputStream)stream);
            stream.flush();
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)graphDBReporter);
            stream.close();
        }
    }

    private void generateReport(GraphDBStateReport graphDBReporter) throws InterruptedException, ExecutionException, IOException {
        String s = (String)graphDBReporter.generateReportForCurrentGDB(null, true, false).get();
        logger.info("Generated report in {}", (Object)s);
    }

    private GraphDBStateReport getGraphDBStateReport() {
        return GraphDBStateReport.newInstance((Path)Paths.get(Config.getWorkDirectory(), "report", "graphdb-cluster-current-node-report.zip"));
    }
}

