/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clustermanagement;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.GraphDBByteString;
import com.google.protobuf.Message;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.grpc.Binding;
import com.ontotext.graphdb.raft.grpc.BooleanData;
import com.ontotext.graphdb.raft.grpc.Data;
import com.ontotext.graphdb.raft.grpc.EvaluatorServiceGrpc;
import com.ontotext.graphdb.raft.grpc.Header;
import com.ontotext.graphdb.raft.grpc.Statement;
import com.ontotext.graphdb.raft.util.RpcOutputStream;
import com.ontotext.graphdb.sesame.sos.SOSSplitQuery;
import com.ontotext.rio.jsonld.InvalidLinkException;
import com.ontotext.rio.jsonld.JSONLD11AbstractRDFWriter;
import com.ontotext.rio.jsonld.JsonLDUtils;
import com.ontotext.rio.jsonld.NoWhitelistPatternsException;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.UnsupportedQueryResultFormatException;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;

@Service
public class QueryEvaluatorService
extends EvaluatorServiceGrpc.EvaluatorServiceImplBase
implements ApplicationListener<PropertyChangedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(QueryEvaluatorService.class);
    private static final int MESSAGE_SIZE = Config.getPropertyAsInt((String)"graphdb.raft.rpc.message.size", (int)ClusterGroup.MESSAGE_SIZE_KB_DEFAULT) * 1024;
    private final SemanticDataManagement dataManagement;
    private volatile boolean serverInitialized;

    @Autowired
    public QueryEvaluatorService(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }

    public void evaluateTupleQuery(com.ontotext.graphdb.raft.grpc.Query request, StreamObserver<Data> responseObserver) {
        Repository repository = this.fetchRepositoryOrFail(request, responseObserver);
        if (repository != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Evaluating tuple query from leader");
            }
            this.evaluateTupleQuery(repository, request, responseObserver);
        }
    }

    public void evaluateGraphQuery(com.ontotext.graphdb.raft.grpc.Query request, StreamObserver<Data> responseObserver) {
        Repository repository = this.fetchRepositoryOrFail(request, responseObserver);
        if (repository != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Evaluating graph query from leader");
            }
            this.evaluateGraphQuery(repository, request, responseObserver);
        }
    }

    public void evaluateBooleanQuery(com.ontotext.graphdb.raft.grpc.Query request, StreamObserver<BooleanData> responseObserver) {
        Repository repository = this.fetchRepositoryOrFail(request, responseObserver);
        if (repository != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Evaluating boolean query from leader");
            }
            this.evaluateBooleanQuery(repository, request, responseObserver);
        }
    }

    public void exportStatements(com.ontotext.graphdb.raft.grpc.Query query, StreamObserver<Data> responseObserver) {
        Repository repository = this.fetchRepositoryOrFail(query, responseObserver);
        if (repository != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Export statements from leader");
            }
            this.exportStatements(repository, query, responseObserver);
        }
    }

    private Repository fetchRepositoryOrFail(com.ontotext.graphdb.raft.grpc.Query request, StreamObserver<? extends Message> responseObserver) {
        Repository repository;
        if (!this.serverInitialized) {
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Server not initialized and cannot accept query requests, yet").withCause((Throwable)new RepositoryException())));
            return null;
        }
        try {
            repository = this.fetchRepository(request);
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.NOT_FOUND.withCause((Throwable)e)));
            return null;
        }
        if (repository == null) {
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.NOT_FOUND.withDescription("No such repository").withCause((Throwable)new RepositoryException())));
        }
        return repository;
    }

    private Repository fetchRepository(com.ontotext.graphdb.raft.grpc.Query request) {
        Optional<String> locationHeader = this.getHeaderValue(request.getHeaderList(), "X-GraphDB-Repository-Location");
        return this.dataManagement.getLocationFromHeaderOrThrow(locationHeader.orElse("")).sesameManager().getRepository(request.getRepository());
    }

    private void evaluateTupleQuery(Repository repository, com.ontotext.graphdb.raft.grpc.Query query, StreamObserver<Data> responseObserver) {
        this.setTrackAlias(query);
        try (RepositoryConnection connection = repository.getConnection();){
            TupleQuery tupleQuery = this.parseTupleQuery(connection, query);
            try (TupleQueryResult result = tupleQuery.evaluate();
                 RpcOutputStream stream = new RpcOutputStream(responseObserver, MESSAGE_SIZE, this.createMessageBuilder());){
                TupleQueryResultFormat format = (TupleQueryResultFormat)QueryResultIO.getWriterFormatForMIMEType((String)query.getMime()).orElseThrow(() -> new UnsupportedQueryResultFormatException("Unknown MIME type for query result format: " + query.getMime()));
                TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)stream);
                writer.getWriterConfig().set((RioSetting)BasicWriterSettings.ENCODE_RDF_STAR, (Object)(!format.supportsRDFStar() ? 1 : 0));
                QueryResults.report((TupleQueryResult)this.resultWithDistinctLimitAndOffset(result, query), (QueryResultHandler)writer);
                this.throwExceptionIfConnectionClosed(connection);
            }
        }
        catch (RuntimeException ex) {
            responseObserver.onError((Throwable)this.buildStatusRuntimeException(ex));
            throw ex;
        }
        responseObserver.onCompleted();
    }

    private void throwExceptionIfConnectionClosed(RepositoryConnection connection) {
        if (!connection.isOpen()) {
            throw new QueryInterruptedException("Query was interrupted");
        }
    }

    @NotNull
    private Function<byte[], Data> createMessageBuilder() {
        return byteData -> Data.newBuilder().setData((ByteString)new GraphDBByteString(byteData)).build();
    }

    private void evaluateGraphQuery(Repository repository, com.ontotext.graphdb.raft.grpc.Query query, StreamObserver<Data> responseObserver) {
        this.setTrackAlias(query);
        try (RepositoryConnection connection = repository.getConnection();){
            GraphQuery graphQuery = this.parseGraphQuery(connection, query);
            try (GraphQueryResult result = graphQuery.evaluate();
                 RpcOutputStream stream = new RpcOutputStream(responseObserver, MESSAGE_SIZE, this.createMessageBuilder());){
                RDFWriter writer = this.getRdfWriter(query.getMime(), stream);
                this.setJSONLD11Profile(query.getHeaderList(), writer, connection);
                QueryResults.report((GraphQueryResult)this.resultWithDistinctLimitAndOffset(result, query), (RDFHandler)writer);
                this.throwExceptionIfConnectionClosed(connection);
            }
        }
        catch (RuntimeException ex) {
            responseObserver.onError((Throwable)this.buildStatusRuntimeException(ex));
            throw ex;
        }
        responseObserver.onCompleted();
    }

    private void exportStatements(Repository repository, com.ontotext.graphdb.raft.grpc.Query query, StreamObserver<Data> responseObserver) {
        try (RpcOutputStream stream = new RpcOutputStream(responseObserver, MESSAGE_SIZE, this.createMessageBuilder());){
            RDFWriter writer = this.getRdfWriter(query.getMime(), stream);
            SimpleValueFactory instance = SimpleValueFactory.getInstance();
            Resource[] contexts = query.getNamedGraphsList().isEmpty() ? new Resource[]{} : (Resource[])query.getNamedGraphsList().stream().map(context -> NTriplesUtil.parseResource((String)context, (ValueFactory)instance)).toArray(Resource[]::new);
            try (RepositoryConnection connection = repository.getConnection();){
                this.setJSONLD11Profile(query.getHeaderList(), writer, connection);
                Statement statement = query.getStatement();
                Resource subject = statement.getSubject().isEmpty() ? null : NTriplesUtil.parseResource((String)statement.getSubject(), (ValueFactory)instance);
                IRI predicate = statement.getPredicate().isEmpty() ? null : NTriplesUtil.parseURI((String)statement.getPredicate(), (ValueFactory)instance);
                Value object = statement.getObject().isEmpty() ? null : NTriplesUtil.parseValue((String)statement.getObject(), (ValueFactory)instance);
                connection.exportStatements(subject, predicate, object, query.getIncludeInferred(), (RDFHandler)writer, contexts);
                this.throwExceptionIfConnectionClosed(connection);
            }
        }
        catch (RuntimeException ex) {
            responseObserver.onError((Throwable)this.buildStatusRuntimeException(ex));
            throw ex;
        }
        responseObserver.onCompleted();
    }

    private void evaluateBooleanQuery(Repository repository, com.ontotext.graphdb.raft.grpc.Query query, StreamObserver<BooleanData> responseObserver) {
        this.setTrackAlias(query);
        try (RepositoryConnection connection = repository.getConnection();){
            BooleanQuery booleanQuery = this.parseBooleanQuery(connection, query);
            boolean booleanResult = booleanQuery.evaluate();
            this.throwExceptionIfConnectionClosed(connection);
            BooleanData booleanBuilder = BooleanData.newBuilder().setResult(booleanResult).build();
            responseObserver.onNext((Object)booleanBuilder);
            responseObserver.onCompleted();
        }
        catch (RuntimeException ex) {
            responseObserver.onError((Throwable)this.buildStatusRuntimeException(ex));
            throw ex;
        }
    }

    private void setJSONLD11Profile(List<Header> headerList, RDFWriter writer, RepositoryConnection connection) {
        if (writer instanceof JSONLD11AbstractRDFWriter) {
            Optional<String> acceptHeader = this.getHeaderValue(headerList, "Accept");
            Optional<String> linkHeader = this.getHeaderValue(headerList, "Link");
            JsonLDUtils.JsonLDProfile jsonLDProfile = JsonLDUtils.parseProfile(acceptHeader, linkHeader);
            ((JSONLD11AbstractRDFWriter)writer).setProfile(jsonLDProfile);
            ((JSONLD11AbstractRDFWriter)writer).setRepoConnection(connection);
        }
    }

    private RDFWriter getRdfWriter(String mimeType, RpcOutputStream stream) {
        RDFFormat format = (RDFFormat)Rio.getWriterFormatForMIMEType((String)mimeType).orElseThrow(() -> new UnsupportedRDFormatException("Unknown MIME type for RDF format: " + mimeType));
        return Rio.createWriter((RDFFormat)format, (OutputStream)stream);
    }

    private void setMetadata(Query query, com.ontotext.graphdb.raft.grpc.Query grpcQuery) {
        if (grpcQuery.getDefaultGraphsCount() > 0 || grpcQuery.getNamedGraphsCount() > 0) {
            SimpleDataset dataset = new SimpleDataset();
            for (String defaultGraph : grpcQuery.getDefaultGraphsList()) {
                dataset.addDefaultGraph(SimpleValueFactory.getInstance().createIRI(defaultGraph));
            }
            for (String namedGraph : grpcQuery.getNamedGraphsList()) {
                dataset.addNamedGraph(SimpleValueFactory.getInstance().createIRI(namedGraph));
            }
            query.setDataset((Dataset)dataset);
        }
        if (grpcQuery.getParametersCount() > 0) {
            for (Binding binding : grpcQuery.getParametersList()) {
                query.setBinding(binding.getName(), Protocol.decodeValue((String)binding.getEncodedValue(), (ValueFactory)SimpleValueFactory.getInstance()));
            }
        }
        query.setIncludeInferred(grpcQuery.getIncludeInferred());
    }

    private TupleQuery parseTupleQuery(RepositoryConnection repositoryCon, com.ontotext.graphdb.raft.grpc.Query query) {
        SOSSplitQuery splitQuery;
        if (query.getIsSOSSplitQuery() && (splitQuery = SOSSplitQuery.parse((String)query.getQuery(), (int)query.getSplitQueryLimit())).getRootQuery().hasSubSteps()) {
            int numOfThreads = Config.getPropertyAsInt((String)"graphdb.sos.cluster.numOfThreads", (int)1);
            splitQuery.setParserOp(arg_0 -> ((RepositoryConnection)repositoryCon).prepareTupleQuery(arg_0));
            splitQuery.build(numOfThreads);
            this.setMetadata((Query)splitQuery, query);
            return splitQuery;
        }
        TupleQuery parsedQuery = repositoryCon.prepareTupleQuery(QueryLanguage.SPARQL, query.getQuery(), StringUtils.trimToNull((String)query.getBase()));
        this.setMetadata((Query)parsedQuery, query);
        return parsedQuery;
    }

    private GraphQuery parseGraphQuery(RepositoryConnection repositoryCon, com.ontotext.graphdb.raft.grpc.Query query) {
        GraphQuery graphQuery = repositoryCon.prepareGraphQuery(QueryLanguage.SPARQL, query.getQuery(), StringUtils.trimToNull((String)query.getBase()));
        this.setMetadata((Query)graphQuery, query);
        return graphQuery;
    }

    private BooleanQuery parseBooleanQuery(RepositoryConnection repositoryCon, com.ontotext.graphdb.raft.grpc.Query query) {
        BooleanQuery parsedQuery = repositoryCon.prepareBooleanQuery(QueryLanguage.SPARQL, query.getQuery(), StringUtils.trimToNull((String)query.getBase()));
        this.setMetadata((Query)parsedQuery, query);
        return parsedQuery;
    }

    private StatusRuntimeException buildStatusRuntimeException(Exception e) {
        Status status = e instanceof MalformedQueryException || e instanceof InvalidLinkException || e instanceof NoWhitelistPatternsException ? Status.INVALID_ARGUMENT : (e instanceof QueryInterruptedException ? Status.ABORTED : (e instanceof QueryEvaluationException || e instanceof RDFHandlerException ? Status.INTERNAL : (e instanceof AccessDeniedException ? Status.PERMISSION_DENIED : Status.UNKNOWN)));
        return new StatusRuntimeException(status.withDescription(e.getMessage()));
    }

    public void onApplicationEvent(PropertyChangedEvent event) {
        if ("semantic.locations.initialized".equals(event.getKey())) {
            this.serverInitialized = true;
        }
    }

    private void setTrackAlias(com.ontotext.graphdb.raft.grpc.Query query) {
        if (StringUtils.isNotEmpty((CharSequence)query.getTrackAlias())) {
            GraphDBHTTPContext.setTrackAlias((String)query.getTrackAlias());
        }
    }

    private TupleQueryResult resultWithDistinctLimitAndOffset(TupleQueryResult queryResult, com.ontotext.graphdb.raft.grpc.Query query) {
        if (query.getDistinct()) {
            queryResult = QueryResults.distinctResults((TupleQueryResult)queryResult);
        }
        return QueryResults.limitResults((TupleQueryResult)queryResult, (long)query.getLimit(), (long)query.getOffset());
    }

    private GraphQueryResult resultWithDistinctLimitAndOffset(GraphQueryResult queryResult, com.ontotext.graphdb.raft.grpc.Query query) {
        if (query.getDistinct()) {
            queryResult = QueryResults.distinctResults((GraphQueryResult)queryResult);
        }
        return QueryResults.limitResults((GraphQueryResult)queryResult, (long)query.getLimit(), (long)query.getOffset());
    }

    @VisibleForTesting
    Optional<String> getHeaderValue(List<Header> headerList, String headerKey) {
        return headerList.stream().filter(header -> headerKey.equalsIgnoreCase(header.getHeaderKey())).map(Header::getHeaderValue).findAny();
    }
}

