/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.accountmanagement;

import com.ontotext.forest.accountmanagement.AddUserUpdate;
import com.ontotext.forest.accountmanagement.DeleteUserUpdate;
import com.ontotext.forest.accountmanagement.EditUserUpdate;
import com.ontotext.forest.accountmanagement.PropertyChangeUpdate;
import com.ontotext.forest.accountmanagement.SavedGraphsUpdate;
import com.ontotext.forest.accountmanagement.SavedQueriesUpdate;
import com.ontotext.forest.accountmanagement.VisualGraphConfigUpdate;
import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.graphexplore.service.SavedGraphService;
import com.ontotext.forest.graphexplore.service.SavedGraphsEvent;
import com.ontotext.forest.graphexplore.service.VisualGraphConfigEvent;
import com.ontotext.forest.graphexplore.service.VisualGraphConfigService;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.sparql.SavedQueriesEvent;
import com.ontotext.forest.sparql.SavedQueriesService;
import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.raft.config.ClusterConfigService;
import com.ontotext.raft.update.SystemUpdate;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Service;

@Primary
@Service
public class ClusteredAccountsService
implements AccountsService,
ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Set<String> HANDLED_EVENT_KEYS = Set.of("security.default.auth.settings", "security.enabled", "security.free.access.authorities", "security.free.access", "security.free.access.settings").stream().map(s -> s + ".replicated").collect(Collectors.toSet());
    private final SavedQueriesService savedQueriesService;
    private final SavedGraphService savedGraphService;
    private final VisualGraphConfigService graphConfigService;
    private final AccountsService delegate;
    private final SemanticDataManagement dataManagement;
    private final SecurityConfig securityConfig;
    private ClusterConfigService configService;
    @Autowired
    private SemanticLocationManagement locationManagement;

    @Autowired
    public ClusteredAccountsService(@Qualifier(value="accountsService") AccountsService delegate, SavedQueriesService savedQueriesService, SavedGraphService savedGraphService, VisualGraphConfigService graphConfigService, SemanticDataManagement dataManagement, SecurityConfig securityConfig) {
        this.delegate = delegate;
        this.savedQueriesService = savedQueriesService;
        this.savedGraphService = savedGraphService;
        this.graphConfigService = graphConfigService;
        this.dataManagement = dataManagement;
        this.securityConfig = securityConfig;
    }

    @PostConstruct
    public void initialize() {
        this.locationManagement.setAccountsService((AccountsService)this);
    }

    public void saveUser(Account account) {
        this.delegate.saveUser(account);
    }

    public void editUserAccount(Account user, boolean updatePassword) {
        this.verifyState();
        this.delegate.editUserAccount(user, updatePassword);
        if (this.isClusterEnabled()) {
            this.replicateSystemUpdate(new EditUserUpdate(user, updatePassword));
        }
    }

    public void addNewUser(Account user) {
        this.verifyState();
        this.delegate.addNewUser(user);
        if (this.isClusterEnabled() && this.isLocal()) {
            this.replicateSystemUpdate(new AddUserUpdate(user));
        }
    }

    public void delete(String username) {
        this.verifyState();
        this.delegate.delete(username);
        if (this.isClusterEnabled() && this.isLocal()) {
            this.replicateSystemUpdate(new DeleteUserUpdate(username));
        }
    }

    public Collection<Account> getAll() {
        return this.delegate.getAll();
    }

    @Nullable
    public Account getAccount(String username) {
        return this.delegate.getAccount(username);
    }

    public Account getDefaultAdminAccount() {
        return this.delegate.getDefaultAdminAccount();
    }

    public Account getAccountOrThrow(String username) {
        return this.delegate.getAccountOrThrow(username);
    }

    public boolean isLocal() {
        return this.delegate.isLocal();
    }

    public AuthenticatedUser loadUserByUsername(String username) {
        return this.delegate.loadUserByUsername(username);
    }

    public AuthenticatedUser loadUserByUsername(String username, Collection<GrantedAuthority> authorities) {
        return this.delegate.loadUserByUsername(username, authorities);
    }

    public String getImplementationName() {
        return this.delegate.getImplementationName();
    }

    public Class<? extends AccountsService> getImplementationClass() {
        return this.delegate.getImplementationClass();
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.delegate.getAuthenticationProvider();
    }

    public Object getServiceConfig() {
        return this.delegate.getServiceConfig();
    }

    public Map<String, Object> getDefaultSettings() {
        return this.delegate.getDefaultSettings();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!this.isClusterEnabled() || !this.isPrimaryLeader()) {
            return;
        }
        if (event instanceof PropertyChangedEvent) {
            this.onPropertyChangedEvent((PropertyChangedEvent)event);
        } else if (event instanceof SavedQueriesEvent) {
            this.onSavedQueriesEvent((SavedQueriesEvent)event);
        } else if (event instanceof VisualGraphConfigEvent) {
            this.onVisualGraphConfigEvent((VisualGraphConfigEvent)event);
        } else if (event instanceof SavedGraphsEvent) {
            this.onSavedGraphsEvent((SavedGraphsEvent)event);
        }
    }

    public void handleEventInCluster(ApplicationEvent event) {
        if (event instanceof SavedQueriesEvent) {
            this.editSavedQueries((SavedQueriesEvent)event);
        } else if (event instanceof VisualGraphConfigEvent) {
            this.editVisualGraphConfig((VisualGraphConfigEvent)event);
        } else if (event instanceof SavedGraphsEvent) {
            this.editSavedGraph((SavedGraphsEvent)event);
        }
    }

    public void changeSecurityConfig(String key, Object value) {
        switch (key) {
            case "security.enabled.replicated": {
                this.securityConfig.setEnabledSecurity(((Boolean)value).booleanValue(), false);
                break;
            }
            case "security.free.access.replicated": {
                this.securityConfig.setEnableFreeAccess(((Boolean)value).booleanValue(), false);
                break;
            }
            case "security.free.access.authorities.replicated": {
                this.securityConfig.setFreeAccessAuthorities((List)value, false);
                break;
            }
            case "security.free.access.settings.replicated": {
                this.securityConfig.setFreeAccessSettings((Map)value, false);
                break;
            }
            case "security.default.auth.settings.replicated": {
                this.securityConfig.setOverrideAuthSettings((Map)value, false);
                break;
            }
            default: {
                LOGGER.warn("Unimplemented security config change for: {}", (Object)key);
            }
        }
    }

    public void editUserAccountInCluster(Account user, boolean updatePassword) {
        this.delegate.editUserAccount(user, updatePassword);
    }

    public void addNewUserInCluster(Account user) {
        this.delegate.addNewUser(user);
    }

    public void deleteInCluster(String username) {
        this.delegate.delete(username);
    }

    private void replicateSystemUpdate(SystemUpdate systemUpdate) {
        if (this.getCluster().replicateSystemUpdate(systemUpdate) < 1L) {
            LOGGER.warn("Could not replicate system update");
        }
    }

    private void verifyState() {
        if (this.isClusterEnabled() && !this.isPrimaryLeader()) {
            throw new RaftException("Cannot replicate system update as node is not leader");
        }
    }

    private boolean isPrimaryLeader() {
        return this.getCluster().isLeader() && this.getCluster().isPrimaryCluster();
    }

    private GraphDBReplicationCluster getCluster() {
        SemanticLocation currentLocation = this.dataManagement.getCurrentLocationOrThrow();
        return currentLocation.getReplicationCluster();
    }

    private boolean isClusterEnabled() {
        ClusterConfigService service = this.getClusterConfigService();
        if (service == null) {
            return false;
        }
        return service.isClusterEnabled();
    }

    private ClusterConfigService getClusterConfigService() {
        if (this.configService == null) {
            SemanticLocation currentLocation = this.dataManagement.getCurrentLocation();
            if (currentLocation == null || !currentLocation.isLocal()) {
                return null;
            }
            this.configService = currentLocation.getClusterConfigService();
        }
        return this.configService;
    }

    private void editSavedQueries(SavedQueriesEvent event) {
        this.savedQueriesService.saveQueriesNoEvent(event.getUsername(), event.getSavedQueries(), true);
    }

    private void editVisualGraphConfig(VisualGraphConfigEvent event) {
        if (event.isDelete()) {
            this.graphConfigService.deleteConfigNoEvent(event.getId());
        } else {
            this.graphConfigService.updateVisualGraphConfigNoEvent(event.getGraphConfig());
        }
    }

    private void editSavedGraph(SavedGraphsEvent event) {
        this.savedGraphService.saveGraphsNoEvent(event.getSavedGraphs());
    }

    private void onSavedQueriesEvent(SavedQueriesEvent event) {
        if (this.isPrimaryLeader()) {
            this.replicateSystemUpdate(new SavedQueriesUpdate(event));
        }
    }

    private void onSavedGraphsEvent(SavedGraphsEvent event) {
        if (this.isPrimaryLeader()) {
            this.replicateSystemUpdate(new SavedGraphsUpdate(event));
        }
    }

    private void onVisualGraphConfigEvent(VisualGraphConfigEvent event) {
        if (this.isPrimaryLeader()) {
            this.replicateSystemUpdate(new VisualGraphConfigUpdate(event));
        }
    }

    private void onPropertyChangedEvent(PropertyChangedEvent event) {
        if (this.isPrimaryLeader() && HANDLED_EVENT_KEYS.contains(event.getKey())) {
            this.replicateSystemUpdate(new PropertyChangeUpdate(event, this.securityConfig));
        }
    }
}

