/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.materialization.impl;

import org.apache.commons.rdf.api.IRI;

final class VocabularyEntry {
    final IRI name;
    final int arity;
    private static final String SELECT_PROPERTY_QUERY_CONTEXT_TEMPLATE = "SELECT DISTINCT ?s ?o ?g WHERE { {?s <%1$s> ?o} UNION {GRAPH ?g {?s <%1$s> ?o}} }";
    private static final String SELECT_CLASS_QUERY_CONTEXT_TEMPLATE = "SELECT DISTINCT ?s ?g WHERE { {?s a <%1$s>}  UNION {GRAPH ?g {?s a <%1$s>}} }";

    VocabularyEntry(IRI predicate, int arity) {
        this.name = predicate;
        this.arity = arity;
    }

    public String toString() {
        return this.name + "/" + this.arity;
    }

    boolean isClass() {
        return this.arity == 1;
    }

    String getIRIString() {
        return this.name.getIRIString();
    }

    String getSelectQuery() {
        return String.format(this.arity == 1 ? SELECT_CLASS_QUERY_CONTEXT_TEMPLATE : SELECT_PROPERTY_QUERY_CONTEXT_TEMPLATE, this.name.getIRIString());
    }
}

