/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.query.impl;

import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.query.resultset.OntopBindingSet;
import it.unibz.inf.ontop.query.resultset.TupleResultSet;
import it.unibz.inf.ontop.rdf4j.query.impl.OntopRDF4JBindingSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class OntopTupleQueryResult
implements TupleQueryResult {
    private final TupleResultSet res;
    private final List<String> signature;

    public OntopTupleQueryResult(TupleResultSet res, List<String> signature) {
        this.res = Objects.requireNonNull(res);
        this.signature = signature;
    }

    public void close() throws QueryEvaluationException {
        try {
            this.res.close();
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public boolean hasNext() throws QueryEvaluationException {
        try {
            return this.res.hasNext();
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public BindingSet next() throws QueryEvaluationException {
        try {
            return new OntopRDF4JBindingSet((OntopBindingSet)this.res.next());
        }
        catch (OntopConnectionException | OntopResultConversionException e) {
            throw new QueryEvaluationException(e);
        }
    }

    public void remove() throws QueryEvaluationException {
        throw new QueryEvaluationException("The query result is read-only. Elements cannot be removed");
    }

    public List<String> getBindingNames() throws QueryEvaluationException {
        return this.signature;
    }
}

