/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.query.impl;

import com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.query.KGQuery;
import it.unibz.inf.ontop.query.RDF4JConstructQuery;
import it.unibz.inf.ontop.query.RDF4JQueryFactory;
import it.unibz.inf.ontop.query.resultset.GraphResultSet;
import it.unibz.inf.ontop.query.resultset.OntopCloseableIterator;
import it.unibz.inf.ontop.rdf4j.query.OntopCloseableStatementIteration;
import it.unibz.inf.ontop.rdf4j.query.impl.AbstractOntopQuery;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import java.util.Collections;
import java.util.Map;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.impl.IteratingGraphQueryResult;
import org.eclipse.rdf4j.query.parser.ParsedDescribeQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class OntopGraphQuery
extends AbstractOntopQuery<ParsedGraphQuery>
implements GraphQuery {
    private final RDF4JQueryFactory inputQueryFactory;

    public OntopGraphQuery(String queryString, ParsedGraphQuery parsedQuery, String baseIRI, OntopConnection ontopConnection, ImmutableMultimap<String, String> httpHeaders, RDF4JQueryFactory inputQueryFactory, OntopSystemSettings settings) {
        super(queryString, baseIRI, parsedQuery, ontopConnection, httpHeaders, settings);
        this.inputQueryFactory = inputQueryFactory;
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        ParsedGraphQuery parsedQuery = (ParsedGraphQuery)this.getParsedQuery();
        RDF4JConstructQuery query = !(parsedQuery instanceof ParsedDescribeQuery) ? this.inputQueryFactory.createConstructQuery(this.getQueryString(), parsedQuery, (BindingSet)this.bindings) : this.inputQueryFactory.createDescribeQuery(this.getQueryString(), (ParsedDescribeQuery)parsedQuery, (BindingSet)this.bindings);
        try {
            OntopStatement stm = this.conn.createStatement();
            if (this.queryTimeout > 0) {
                stm.setQueryTimeout(this.queryTimeout);
            }
            GraphResultSet res = (GraphResultSet)stm.execute((KGQuery)query, this.getHttpHeaders());
            return new IteratingGraphQueryResult(Collections.emptyMap(), (CloseableIteration)new OntopCloseableStatementIteration((OntopCloseableIterator<RDFFact, OntopConnectionException>)res.iterator()));
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        try (GraphQueryResult result = this.evaluate();){
            handler.startRDF();
            Map namespaces = ((ParsedGraphQuery)this.getParsedQuery()).getQueryNamespaces();
            namespaces.forEach((arg_0, arg_1) -> ((RDFHandler)handler).handleNamespace(arg_0, arg_1));
            result.forEach(arg_0 -> ((RDFHandler)handler).handleStatement(arg_0));
            handler.endRDF();
        }
    }
}

