/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.query.impl;

import com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopQueryAnsweringException;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.query.KGQuery;
import it.unibz.inf.ontop.query.RDF4JAskQuery;
import it.unibz.inf.ontop.query.RDF4JQueryFactory;
import it.unibz.inf.ontop.query.resultset.BooleanResultSet;
import it.unibz.inf.ontop.rdf4j.query.impl.AbstractOntopQuery;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;

public class OntopBooleanQuery
extends AbstractOntopQuery<ParsedBooleanQuery>
implements BooleanQuery {
    private final RDF4JQueryFactory factory;

    public OntopBooleanQuery(String queryString, ParsedBooleanQuery q, String baseIRI, OntopConnection ontopConnection, ImmutableMultimap<String, String> httpHeaders, RDF4JQueryFactory inputQueryFactory, OntopSystemSettings settings) {
        super(queryString, baseIRI, q, ontopConnection, httpHeaders, settings);
        this.factory = inputQueryFactory;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean evaluate() throws QueryEvaluationException {
        RDF4JAskQuery query = this.factory.createAskQuery(this.getQueryString(), (ParsedBooleanQuery)this.getParsedQuery(), (BindingSet)this.bindings);
        try (OntopStatement stm = this.conn.createStatement();){
            boolean bl;
            block15: {
                if (this.queryTimeout > 0) {
                    stm.setQueryTimeout(this.queryTimeout);
                }
                BooleanResultSet rs = (BooleanResultSet)stm.execute((KGQuery)query, this.getHttpHeaders());
                try {
                    bl = rs.getValue();
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (OntopConnectionException | OntopQueryAnsweringException e) {
            throw new QueryEvaluationException(e);
        }
    }
}

