/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.schema.preprocess;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.query.Arguments;
import com.ontotext.script.ValueGenerator;
import com.ontotext.script.schema.preprocess.DataGenerator;
import com.ontotext.script.schema.preprocess.ExpressionsErrorReporter;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.soaas.common.validation.ValidationPatterns;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExpressionValidator
implements SchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaExpressionValidator.class);

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse response = new OperationResponse();
        DataGenerator dataGenerator = new DataGenerator();
        try (ValueGenerator valueGenerator = new ValueGenerator();){
            for (Shape shape : somlSchema.getObjects().values()) {
                this.validateShape(shape, response, valueGenerator, dataGenerator);
            }
        }
        return response;
    }

    private void validateShape(Shape shape, OperationResponse response, ValueGenerator generator, DataGenerator dataGenerator) {
        SchemaExpressionValidator.shapePatternShouldResultToDynamicIri(shape, generator, response, dataGenerator);
        for (PropertyShape propertyShape : shape.getProps().values()) {
            if (!propertyShape.isTracked("gen")) continue;
            if (propertyShape.isMultivalued()) {
                response.addErrorMessage("scripts.generation.not.allowed.for.multivalue.properties", new Object[]{String.join((CharSequence)".", shape.getId(), propertyShape.getName())});
                continue;
            }
            this.propertyExpressionShouldBeValid(propertyShape, response, generator, dataGenerator);
        }
        this.expressionsShouldNotDefineReferenceCycles(shape, response, generator, dataGenerator);
    }

    private void expressionsShouldNotDefineReferenceCycles(Shape shape, OperationResponse response, ValueGenerator generator, DataGenerator dataGenerator) {
        Map dummyData = dataGenerator.generateDataFor(shape);
        Set generatableProperties = shape.getProps().values().stream().filter(property -> StringUtils.isNotBlank((CharSequence)property.getGen()) && property.isTracked("gen")).map(PropertyShape::getName).collect(Collectors.toSet());
        if (generatableProperties.isEmpty()) {
            return;
        }
        dummyData.keySet().removeAll(generatableProperties);
        dummyData.values().removeIf(Map.class::isInstance);
        CreateMutation mutation = new CreateMutation();
        mutation.setReturnTypeInstance(shape);
        Arguments arguments = new Arguments();
        mutation.setArguments(arguments);
        Change change = Change.forCreate((String)ReferenceId.randomId(), (Shape)shape);
        dummyData.forEach((name, value) -> change.addPropertyValue(StringManipulation.replaceColonWithUnderscore((String)name), value));
        arguments.setChanges(Collections.singletonList(change));
        try {
            generator.generateValues((Mutation)mutation);
        }
        catch (RuntimeException pe) {
            ExpressionsErrorReporter.getReporter(response, shape.getId(), shape).accept(pe);
        }
    }

    private void propertyExpressionShouldBeValid(PropertyShape property, OperationResponse response, ValueGenerator generator, DataGenerator dataGenerator) {
        Shape shape = property.getContainedIn().getContainedIn();
        String expressionPath = String.join((CharSequence)".", shape.getId(), property.getName(), "gen");
        Consumer<Exception> errorReporter = ExpressionsErrorReporter.getReporter(response, expressionPath, shape);
        Map dummyData = dataGenerator.generateDataFor(shape);
        String expression = property.getGen();
        String range = SchemaExpressionValidator.resolveRange(property);
        Object value = SchemaExpressionValidator.evalExpression(expression, range, generator, dummyData, errorReporter, shape);
        if ("ID".equals(range)) {
            SchemaExpressionValidator.isValidIri(value, expressionPath, response);
        }
    }

    private static String resolveRange(PropertyShape propertyShape) {
        if (propertyShape.isScalarType()) {
            return propertyShape.getScalarType().getGraphql();
        }
        return "ID";
    }

    private static void shapePatternShouldResultToDynamicIri(Shape shape, ValueGenerator valueGenerator, OperationResponse response, DataGenerator dataGenerator) {
        Map dummyData1;
        if (!shape.isTracked("pattern")) {
            return;
        }
        String expressionPath = shape.getId() + ".pattern";
        Consumer<Exception> errorReporter = ExpressionsErrorReporter.getReporter(response, expressionPath, shape);
        Object firstIri = SchemaExpressionValidator.evalIri(shape, valueGenerator, errorReporter, dummyData1 = dataGenerator.generateDataFor(shape));
        if (!SchemaExpressionValidator.isValidIri(firstIri, expressionPath, response)) {
            return;
        }
        Map dummyData2 = dataGenerator.generateDataFor(shape);
        Object secondIri = SchemaExpressionValidator.evalIri(shape, valueGenerator, errorReporter, dummyData2);
        if (firstIri.equals(secondIri)) {
            response.addErrorMessage("scripts.object.pattern.shouldNotResultToConstant", new Object[]{shape.getId()});
        }
    }

    private static Object evalIri(Shape shape, ValueGenerator valueGenerator, Consumer<Exception> errorReporter, Map<String, Object> data) {
        return SchemaExpressionValidator.evalExpression(shape.getPattern(), "ID", valueGenerator, data, errorReporter, shape);
    }

    private static Object evalExpression(String expression, String range, ValueGenerator valueGenerator, Map<String, Object> values, Consumer<Exception> onError, Shape shape) {
        try {
            if ("ID".equals(range)) {
                return valueGenerator.genIri(expression, values, shape);
            }
            return valueGenerator.genValue(expression, values, shape);
        }
        catch (Exception re) {
            onError.accept(re);
            return null;
        }
    }

    private static boolean isValidIri(Object value, String expressionPath, OperationResponse response) {
        if (value == null) {
            return false;
        }
        String iri = Objects.toString(value);
        if (ValidationPatterns.isValidIri((String)iri)) {
            return true;
        }
        LOGGER.debug("'{}' generated invalid IRI value - '{}'", (Object)expressionPath, (Object)iri);
        response.addErrorMessage("scripts.invalid.iri.expression", new Object[]{expressionPath});
        return false;
    }
}

