/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.schema.preprocess;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.script.EvaluationCycleException;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExpressionsErrorReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("Unresolved reference: (.+)\\s");

    private ExpressionsErrorReporter() {
    }

    static Consumer<Exception> getReporter(OperationResponse response, String expressionPath, Shape shape) {
        return error -> {
            if (error instanceof EvaluationCycleException) {
                EvaluationCycleException ece = (EvaluationCycleException)error;
                response.addErrorMessage("scripts.expression.cycle", new Object[]{expressionPath, ece.getBindingName(), ece.getExpression()});
            } else {
                Throwable patt0$temp = error.getCause();
                if (patt0$temp instanceof EvaluationCycleException) {
                    EvaluationCycleException ece = (EvaluationCycleException)patt0$temp;
                    response.addErrorMessage("scripts.expression.cycle", new Object[]{expressionPath, ece.getBindingName(), ece.getExpression()});
                } else {
                    Matcher matcher = REFERENCE_PATTERN.matcher(ExpressionsErrorReporter.resolveFirstMessage(error));
                    if (matcher.find()) {
                        ExpressionsErrorReporter.handleReferenceError(response, matcher.group(1), expressionPath, shape);
                    } else {
                        LOGGER.error(error.getMessage());
                        response.addErrorMessage("scripts.invalid.expression", new Object[]{expressionPath, ExpressionsErrorReporter.processOriginalMessage(error)});
                    }
                }
            }
        };
    }

    private static void handleReferenceError(OperationResponse response, String error, String expressionPath, Shape shape) {
        String propertyName = error;
        String message = "scripts.invalid.reference";
        if (ExpressionsErrorReporter.isMultivalueProperty(shape, propertyName)) {
            message = "scripts.generation.should.not.refer.multivalue.property";
        }
        response.addErrorMessage(message, new Object[]{expressionPath, propertyName});
    }

    private static boolean isMultivalueProperty(Shape shape, String propertyName) {
        return shape.getProperty(propertyName).map(PropertyShape::isMultivalued).orElse(false);
    }

    private static String processOriginalMessage(Exception error) {
        return ExpressionsErrorReporter.resolveFirstMessage(error).replace("SyntaxError: ", "").replaceAll("<?\\w+?>?:\\d+:\\d+\\s*", "");
    }

    private static String resolveFirstMessage(Exception exception) {
        if (exception.getMessage() != null) {
            if (exception.getMessage().startsWith("Failed to evaluate expression") && exception.getCause() != null && exception.getCause().getMessage() != null && REFERENCE_PATTERN.matcher(exception.getCause().getMessage()).find()) {
                return exception.getCause().getMessage();
            }
            return exception.getMessage();
        }
        if (exception.getCause() != null && exception.getCause().getMessage() != null) {
            return exception.getCause().getMessage();
        }
        return "";
    }
}

