/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json.converters.unsigned;

import com.google.common.primitives.UnsignedLong;
import com.ontotext.rdf.transformer.graphql.json.converters.BaseNumberValueConverter;
import java.math.BigInteger;
import java.util.Objects;

public class UnsignedLongValueConverter
extends BaseNumberValueConverter {
    private static final BigInteger UNSIGNED_LONG_MAX_VALUE = new BigInteger(String.valueOf(UnsignedLong.MAX_VALUE));

    @Override
    public String convert(Object value) {
        BigInteger response = this.toBigInteger(value);
        return Objects.toString(response, null);
    }

    @Override
    public String convertStrict(Object value) {
        if (value == null) {
            return null;
        }
        BigInteger response = this.toBigInteger(value);
        if (response == null) {
            throw this.invalidValue(value);
        }
        this.checkRange(response, BigInteger.ZERO, UNSIGNED_LONG_MAX_VALUE);
        return response.toString();
    }

    @Override
    public String getSupportedType() {
        return "UnsignedLong";
    }
}

