/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json.converters.duration;

import com.ontotext.rdf.transformer.graphql.json.converters.duration.BaseDurationValueConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DurationValueConverter
extends BaseDurationValueConverter {
    private static final Pattern DURATION_PATTERN = Pattern.compile("-?P(\\d+Y)?(\\d+M)?(\\d+D)?(T)?(\\d+H)?(\\d+M)?(\\d+(?:\\.\\d+)?S)?");

    @Override
    protected boolean isDurationValid(String value) {
        Matcher matcher = DURATION_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return false;
        }
        boolean hasTimeSeparator = StringUtils.isNotBlank((CharSequence)matcher.group(4));
        if (!hasTimeSeparator) {
            boolean years = StringUtils.isNotBlank((CharSequence)matcher.group(1));
            boolean months = StringUtils.isNotBlank((CharSequence)matcher.group(2));
            boolean days = StringUtils.isNotBlank((CharSequence)matcher.group(3));
            boolean hours = StringUtils.isNotBlank((CharSequence)matcher.group(5));
            boolean minutes = StringUtils.isNotBlank((CharSequence)matcher.group(6));
            boolean seconds = StringUtils.isNotBlank((CharSequence)matcher.group(7));
            if ((years || months || days) && (hours || minutes || seconds) || !years && !months && !days && !hours && !minutes && !seconds) {
                return false;
            }
        } else if (StringUtils.isBlank((CharSequence)matcher.group(5)) && StringUtils.isBlank((CharSequence)matcher.group(6)) && StringUtils.isBlank((CharSequence)matcher.group(7))) {
            return false;
        }
        return true;
    }

    @Override
    public String getSupportedType() {
        return "Duration";
    }
}

