/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json.converters;

import com.ontotext.rdf.transformer.graphql.json.converters.BaseNumberValueConverter;
import java.math.BigDecimal;

public class DoubleValueConverter
extends BaseNumberValueConverter {
    private static final BigDecimal DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final BigDecimal DOUBLE_MIN_VALUE = DOUBLE_MAX_VALUE.negate();

    @Override
    public Object convert(Object doubleValue) {
        if (doubleValue instanceof Double) {
            return doubleValue;
        }
        if (doubleValue instanceof BigDecimal) {
            return ((BigDecimal)doubleValue).doubleValue();
        }
        if (doubleValue instanceof String) {
            return this.stringToBigDecimal(doubleValue).doubleValue();
        }
        if (doubleValue instanceof Float) {
            return new BigDecimal(doubleValue.toString()).doubleValue();
        }
        if (doubleValue instanceof Integer || doubleValue instanceof Long) {
            return ((Number)doubleValue).doubleValue();
        }
        return null;
    }

    @Override
    public Object convertStrict(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number) && !(value instanceof String)) {
            throw this.invalidValue(value);
        }
        if (value instanceof BigDecimal) {
            this.checkRange((BigDecimal)value);
            return ((BigDecimal)value).doubleValue();
        }
        if (value instanceof String) {
            BigDecimal decimal = this.stringToBigDecimal(value);
            this.checkRange(decimal);
            return decimal.doubleValue();
        }
        return this.convert(value);
    }

    private void checkRange(BigDecimal value) {
        if (value.compareTo(DOUBLE_MAX_VALUE) > 0 || value.compareTo(DOUBLE_MIN_VALUE) < 0) {
            throw this.outOfRange(value);
        }
    }

    @Override
    public String getSupportedType() {
        return "Float";
    }
}

