/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.ontotext.rdf.transformer.graphql.json.ValueConverter;
import com.ontotext.rdf.transformer.graphql.json.converters.PassThroughValueConverter;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class ValueConverterFactory {
    private final Function<ValueConverter, ValueConverter> remappingFunction;
    private Map<String, ValueConverter> valueConverterMap;
    private ValueConverter defaultValueConverter = PassThroughValueConverter.INSTANCE;

    public ValueConverterFactory() {
        this(UnaryOperator.identity());
    }

    public ValueConverterFactory(UnaryOperator<ValueConverter> remappingFunction) {
        this.remappingFunction = remappingFunction == null ? UnaryOperator.identity() : remappingFunction;
    }

    public static ValueConverterFactory relaxedConverters() {
        return new ValueConverterFactory(ValueConverter::toRelaxedConverter);
    }

    public static ValueConverterFactory strictConverters() {
        return new ValueConverterFactory(ValueConverter::toStrictConverter);
    }

    public ValueConverter getConverter(String type) {
        return this.getValueConverters().getOrDefault(type, this.defaultValueConverter);
    }

    private Map<String, ValueConverter> getValueConverters() {
        if (this.valueConverterMap == null) {
            HashMap<String, ValueConverter> valueConvertersHashMap = new HashMap<String, ValueConverter>();
            List valueConverters = PluginsManager.loadPlugins(ValueConverter.class);
            for (ValueConverter converter : valueConverters) {
                ValueConverter valueConverter = valueConvertersHashMap.put(converter.getSupportedType(), this.remappingFunction.apply(converter));
                if (valueConverter == null) continue;
                throw new IllegalStateException("Found duplicate value converter for " + converter.getSupportedType());
            }
            this.valueConverterMap = valueConvertersHashMap;
        }
        return this.valueConverterMap;
    }

    public ValueConverter getDefaultValueConverter() {
        return this.defaultValueConverter;
    }

    public void setDefaultValueConverter(ValueConverter defaultValueConverter) {
        this.defaultValueConverter = defaultValueConverter;
    }
}

