/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.rdf.transformer.SerializationError;
import com.ontotext.rdf.transformer.SerializationResponse;
import com.ontotext.rdf.transformer.ValueSerializer;
import com.ontotext.rdf.transformer.graphql.json.ErrorHandler;
import com.ontotext.rdf.transformer.graphql.json.ResponseValueFilter;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.LiteralValue;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.soaas.common.rdf.ValueReader;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class TransformState {
    public static final String HIDE_PREDICATE = "_hide";
    public static final String TYPENAME = "__typename";
    private static final Map<String, Function<Selectable, String>> SELECTION_MAPPINGS = new HashMap<String, Function<Selectable, String>>();
    private static final String NOT_FOUND = "@notFound@";
    private static final String[] NOT_FOUND_ARRAY = new String[]{"@notFound@"};
    private Deque<Object> path = new LinkedList<Object>();
    private Map<String, Properties> typeToPropertiesCache = new HashMap<String, Properties>();
    private Long2ObjectMap<String[]> idToTypeCache = new Long2ObjectOpenHashMap();
    private Object2BooleanMap<LongList> subselectionToRequiredCache = new Object2BooleanOpenHashMap();
    private final long soTypeIri;
    private final SomlSchema schema;
    private final RdfTree rdfTree;
    private final ErrorHandler errorHandler;
    private final ValueReader soTypeValueReader;
    private final ValueSerializer valueSerializer;
    private final List<ResponseValueFilter> responseValueFilters;
    private final boolean nullArrays;
    private final long hidePredicate;

    TransformState(final SomlSchema schema, final RdfTree rdfTree, ValueSerializer valueSerializer, List<ResponseValueFilter> responseValueFilters, boolean nullArrays, ErrorHandler errorHandler) {
        this.valueSerializer = valueSerializer;
        this.schema = schema;
        this.rdfTree = rdfTree;
        this.errorHandler = errorHandler;
        this.soTypeValueReader = new ValueReader(){
            private Shapes shapes;
            {
                this.shapes = schema.getObjects();
            }

            public Object read(Object object) {
                Object value = rdfTree.getValueReader().read(object);
                return this.shapes.resolveByType(value.toString(), Shape::asGraphQl);
            }

            public LiteralValue readAsLiteral(Object object) {
                return rdfTree.getValueReader().readAsLiteral(object);
            }
        };
        this.responseValueFilters = new ArrayList<ResponseValueFilter>(responseValueFilters);
        this.nullArrays = nullArrays;
        this.soTypeIri = rdfTree.getPool().resolve((Object)this.toIri("so:type"));
        this.hidePredicate = rdfTree.getPool().resolve((Object)this.toIri(HIDE_PREDICATE));
        this.reportProcessingErrors();
    }

    private void reportProcessingErrors() {
        this.rdfTree.findAtAnyDepth("http://www.ontotext.com/semantic-object/result/ERROR", "http://www.ontotext.com/semantic-object/result/ERROR", null).stream().map(Triple::getObject).map(message -> Collections.singletonMap("message", message)).forEach(this.getErrorHandler()::onProcessingError);
    }

    boolean isDataValidForThisSelection(RdfPath rdfPath, Selectable selection) {
        if (selection.getParent() instanceof Subscription) {
            return true;
        }
        Shape shape = selection.getDefinedInType();
        if (shape.isIgnoredType()) {
            return true;
        }
        String definedIn = shape.getId();
        LongList cacheKey = TransformState.getCacheKey(rdfPath, definedIn);
        return this.subselectionToRequiredCache.computeIfAbsent((Object)cacheKey, pathKey -> this.isDataValidForThisSelection(rdfPath, shape));
    }

    private boolean isDataValidForThisSelection(RdfPath rdfPath, Shape definedIn) {
        boolean safeToAdd = false;
        String[] types = this.getTypeFromRdfData(rdfPath);
        if (!this.isNotFound(types[0])) {
            for (String type : types) {
                List definitionHierarchy = this.schema.getObjects().getHierarchy(type);
                boolean bl = safeToAdd = definitionHierarchy.stream().anyMatch(shape -> shape.getId().equals(definedIn.getId())) || definedIn.isUnion() && definedIn.getConcreteSubTypes().stream().anyMatch(member -> this.isDataValidForThisSelection(rdfPath, (Shape)member));
                if (!safeToAdd) {
                    continue;
                }
                break;
            }
        } else {
            safeToAdd = true;
        }
        return safeToAdd;
    }

    private static LongList getCacheKey(RdfPath rdfPath, String definedIn) {
        LongArrayList pathKey = new LongArrayList(2);
        pathKey.add(rdfPath.tail().getObject());
        pathKey.add(rdfPath.getPool().resolve((Object)definedIn));
        return pathKey;
    }

    private boolean isNotFound(Object type) {
        return NOT_FOUND.equals(type);
    }

    boolean isSelectionApplicable(RdfPath currentNode, Selectable selection) {
        if (!selection.isRequestedByUser()) {
            return false;
        }
        if (selection.getParent() instanceof Subscription) {
            return true;
        }
        String[] soType = this.getTypeFromRdfData(currentNode);
        if (this.isNotFound(soType[0])) {
            return true;
        }
        Shape definedInType = selection.getDefinedInType();
        List domainConstraints = selection.getDomainConstraints();
        return this.doesTypeMatchTo(selection, soType, definedInType) || domainConstraints.stream().filter(domain -> !domain.getId().equals(definedInType.getId())).anyMatch(domain -> this.doesTypeMatchTo(selection, soType, (Shape)domain));
    }

    private boolean doesTypeMatchTo(Selectable selection, String[] soType, Shape definedInType) {
        if (definedInType.isIgnoredType()) {
            return true;
        }
        if (this.matchUnionType(definedInType, soType)) {
            return true;
        }
        String definedIn = definedInType.getId();
        if (!this.matchOneOfTheTypesInHierarchy(soType, definedIn)) {
            return false;
        }
        if (SELECTION_MAPPINGS.containsKey(selection.getName())) {
            return true;
        }
        return Stream.of(soType).anyMatch(type -> this.typeToPropertiesCache.computeIfAbsent((String)type, arg_0 -> ((Shapes)this.schema.getObjects()).getAllShapeProperties(arg_0)).containsKey((Object)selection.getNameShortIri()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchOneOfTheTypesInHierarchy(String[] soType, String definedIn) {
        if (soType.length != 1) return Stream.of(soType).anyMatch(type -> {
            if (type.equals(definedIn)) return true;
            if (!this.schema.getObjects().getHierarchy(type).stream().map(Shape::getId).anyMatch(definedIn::equals)) return false;
            return true;
        });
        if (soType[0].equals(definedIn)) return true;
        if (!this.schema.getObjects().getHierarchy(soType[0]).stream().map(Shape::getId).anyMatch(definedIn::equals)) return false;
        return true;
    }

    private boolean matchUnionType(Shape definedInType, String[] soType) {
        if (soType.length == 1) {
            return definedInType.isUnion() && definedInType.getConcreteSubTypes().stream().anyMatch(member -> member.getId().equals(soType[0]));
        }
        for (String type : soType) {
            if (!definedInType.isUnion() || !definedInType.getConcreteSubTypes().stream().anyMatch(member -> member.getId().equals(type))) continue;
            return true;
        }
        return false;
    }

    private String[] getTypeFromRdfData(RdfPath currentNode) {
        return (String[])this.idToTypeCache.computeIfAbsent(currentNode.tail().getObject(), this::readBoType);
    }

    private String[] readBoType(long id) {
        EntityPool pool = this.rdfTree.getPool();
        List values = this.rdfTree.findAtAnyDepth(id, this.soTypeIri, 0L).stream().map(triple -> pool.get(triple.getObject())).collect(Collectors.toList());
        String[] types = (String[])this.valueSerializer.serialize(null, values, this.soTypeValueReader).getValues().stream().map(Object::toString).distinct().map(this::nameToShortIri).toArray(String[]::new);
        if (types.length == 0) {
            return NOT_FOUND_ARRAY;
        }
        return types;
    }

    protected Object filterSimpleValue(Selectable selection, List<Object> values) {
        block5: {
            block7: {
                String type;
                Shape shape;
                block6: {
                    if (values.size() <= 1 || !selection.getName().equals(TYPENAME)) break block5;
                    shape = selection.getDefinedInType();
                    if (shape.isAbstract()) break block6;
                    if (!shape.isUnion()) break block7;
                }
                if ((type = (String)shape.getConcreteSubTypes().stream().map(Shape::asGraphQl).filter(values::contains).findFirst().orElse(null)) != null) {
                    return type;
                }
            }
            if (values.contains(selection.getDefinedIn())) {
                return selection.getDefinedIn();
            }
        }
        return selection.isCollection() ? values : values.get(0);
    }

    List<Object> getValues(RdfPath rdfPath, Selectable selection) {
        String selectionName = selection.getName();
        String selectionPredicateIri = selection.getResponseNameIri();
        ValueReader valueReader = this.rdfTree.getValueReader();
        Shape shape = selection.getDefinedInType();
        if (this.shouldHideTheSelection(rdfPath, selectionName)) {
            return Collections.singletonList(null);
        }
        if ("id".equals(selectionName)) {
            PropertyShape id = shape.getProperty(selectionName).orElse(null);
            SerializationResponse response = this.valueSerializer.serialize(id, Collections.singletonList(rdfPath.getObjectValue()), valueReader);
            return response.getValues();
        }
        if (SELECTION_MAPPINGS.containsKey(selectionName)) {
            if (selectionName.equals(TYPENAME)) {
                valueReader = this.soTypeValueReader;
                if (!shape.isAbstract() && shape.isIgnoredType()) {
                    return List.of(shape.asGraphQl());
                }
            }
            selectionName = this.nameToShortIri(SELECTION_MAPPINGS.get(selectionName).apply(selection));
            if (selection.getAlias() == null) {
                selectionPredicateIri = this.toIri(selectionName);
            }
        }
        Collection<Object> values = this.resolveValuesForPath(rdfPath, selection, selectionPredicateIri);
        PropertyShape propertyShape = shape.getProperty(selectionName).orElseGet(() -> this.tryToResolvePropertyShape(selection));
        SerializationResponse response = this.valueSerializer.serialize(propertyShape, values, valueReader);
        this.addConversionErrors(response, selection);
        return this.applyValueFilters(selection, response);
    }

    private PropertyShape tryToResolvePropertyShape(Selectable selection) {
        Shape type = selection.getDefinedInType();
        String nameShortIri = selection.getNameShortIri();
        if ("name".equals(selection.getName())) {
            nameShortIri = type.getName();
            if (nameShortIri == null) {
                return null;
            }
            nameShortIri = this.nameToShortIri(nameShortIri);
        }
        return type.getProperty(nameShortIri).orElseGet(this.tryToResolvePropertyByName(selection));
    }

    private Supplier<PropertyShape> tryToResolvePropertyByName(Selectable selection) {
        return () -> {
            if (SELECTION_MAPPINGS.containsKey(selection.getName())) {
                return null;
            }
            String name = selection.getName();
            Shape type = selection.getDefinedInType();
            return type.getProperty(name).orElse(null);
        };
    }

    private boolean shouldHideTheSelection(RdfPath rdfPath, String selectionName) {
        if (!selectionName.equals("id")) {
            return false;
        }
        return this.rdfTree.contains(rdfPath.tail().getObject(), this.hidePredicate, 0L);
    }

    private List<Object> applyValueFilters(Selectable selection, SerializationResponse response) {
        List values = response.getValues();
        if (!values.isEmpty()) {
            for (ResponseValueFilter valueFilter : this.responseValueFilters) {
                valueFilter.filterValues(values, selection);
            }
        }
        return values;
    }

    private Collection<Object> resolveValuesForPath(RdfPath rdfPath, Selectable selection, String selectionPredicateIri) {
        if (selection.getParent() instanceof Subscription && TYPENAME.equals(selection.getName())) {
            return Collections.singletonList(selection.getDefinedIn());
        }
        boolean canQueryViaIndex = !selection.isComplexType() || "Literal".equals(selection.getType());
        EntityPool pool = this.rdfTree.getPool();
        long predicate = pool.resolve((Object)selectionPredicateIri);
        if (canQueryViaIndex) {
            Collection valueTriples = this.rdfTree.findAtAnyDepth(rdfPath.tail().getObject(), predicate, 0L);
            return valueTriples.stream().map(triple -> pool.get(triple.getObject())).collect(Collectors.toList());
        }
        RdfPath selectPattern = rdfPath.add(predicate, 0L);
        return this.rdfTree.select(selectPattern).stream().map(Triple::getObject).collect(Collectors.toList());
    }

    private void addConversionErrors(SerializationResponse response, Selectable selection) {
        if (response.isValid()) {
            return;
        }
        for (SerializationError error : response.getErrors()) {
            this.getErrorHandler().onSerializationError(error, selection, this.path);
        }
    }

    private String nameToShortIri(String name) {
        return this.schema.getPrefixes().nameToShortIri(name);
    }

    private String toIri(String rdfName) {
        return this.schema.getPrefixes().toIri(rdfName);
    }

    void stepIn(Selectable selectable) {
        this.path.addLast(selectable.getResponseName());
    }

    void stepIn(Integer value) {
        this.path.addLast(value);
    }

    void stepOut() {
        this.path.removeLast();
    }

    String computePredicate(Selectable selection) {
        String selectionName = selection.getName();
        if ("id".equals(selectionName)) {
            throw new IllegalArgumentException("'id' selection does not have a predicate equivalent");
        }
        if (SELECTION_MAPPINGS.containsKey(selectionName)) {
            selectionName = SELECTION_MAPPINGS.get(selectionName).apply(selection);
            if (selection.getAlias() == null) {
                return this.toIri(this.nameToShortIri(selectionName));
            }
        }
        return selection.getResponseNameIri();
    }

    public Object getNullValue(Selectable selection) {
        if (selection.isCountSelection()) {
            return 0;
        }
        return selection.isCollection() && !this.nullArrays ? new ArrayList(2) : null;
    }

    public Deque<Object> getPath() {
        return this.path;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    static {
        SELECTION_MAPPINGS.put("id", selectable -> null);
        SELECTION_MAPPINGS.put("type", selectable -> "rdf:type");
        SELECTION_MAPPINGS.put("name", selectable -> "so:name");
        SELECTION_MAPPINGS.put(TYPENAME, selectable -> "so:type");
    }
}

